/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item;

import com.human.common.gameplay.item.CanisterItem;
import com.human.common.registry.init.HumanDataComponents;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;

public class SolidCanisterItem
extends BlockItem {
    private final SoundEvent placeSound;

    public SolidCanisterItem(Block block, SoundEvent placeSound, Item.Properties properties) {
        super(block, properties);
        this.placeSound = placeSound;
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltipComponents, @NotNull TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        int currentContentAmount = (Integer)stack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
        if (currentContentAmount == 0) {
            return;
        }
        tooltipComponents.add((Component)Component.translatable((String)"tooltip.avp.capacity").append(currentContentAmount + "/8"));
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        UseOnContext modifiedContext = new UseOnContext(context.getLevel(), player, context.getHand(), context.getItemInHand().copy(), SolidCanisterItem.getPlayerPOVHitResult((Level)context.getLevel(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE));
        InteractionResult result = super.useOn(modifiedContext);
        if (result.consumesAction() && player.isShiftKeyDown()) {
            int contentAmount = (Integer)context.getItemInHand().getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
            if (contentAmount > 1 && !player.isCreative()) {
                CanisterItem.updateCapacity(context.getItemInHand(), -1);
                return result;
            }
            player.setItemInHand(context.getHand(), CanisterItem.getEmptySuccessItem(context.getItemInHand(), player));
            return InteractionResult.SUCCESS;
        }
        BlockHitResult hitResult = SolidCanisterItem.getPlayerPOVHitResult((Level)context.getLevel(), (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (CanisterItem.isInvalidHitResult(hitResult)) {
            return InteractionResult.PASS;
        }
        BlockPos hitPos = hitResult.getBlockPos();
        Direction hitDir = hitResult.getDirection();
        BlockPos relativePos = hitPos.relative(hitDir);
        if (!CanisterItem.canPlayerInteract(context.getLevel(), player, hitPos, relativePos, hitDir, context.getItemInHand())) {
            return InteractionResult.FAIL;
        }
        BlockState hitState = context.getLevel().getBlockState(hitPos);
        if (CanisterItem.isFluidPickupAction(player, hitState)) {
            return this.handlePowderSnowPickup(player, context.getLevel(), context.getItemInHand(), hitPos, hitState);
        }
        return InteractionResult.FAIL;
    }

    private InteractionResult handlePowderSnowPickup(Player player, Level level, ItemStack canisterStack, BlockPos hitPos, BlockState hitState) {
        BucketPickup bucketPickup = (BucketPickup)hitState.getBlock();
        if ((Integer)canisterStack.getOrDefault(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0) >= 8) {
            return InteractionResult.FAIL;
        }
        bucketPickup.pickupBlock(player, (LevelAccessor)level, hitPos, hitState);
        player.awardStat(Stats.ITEM_USED.get((Object)this));
        bucketPickup.getPickupSound().ifPresent(sound -> player.playSound(sound, 1.0f, 1.0f));
        level.gameEvent((Entity)player, (Holder)GameEvent.FLUID_PICKUP, hitPos);
        CanisterItem.updateCapacity(canisterStack, 1);
        if (!level.isClientSide) {
            CriteriaTriggers.FILLED_BUCKET.trigger((ServerPlayer)player, canisterStack);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    protected boolean placeBlock(BlockPlaceContext context, @NotNull BlockState state) {
        return context.getPlayer() != null && context.getPlayer().isShiftKeyDown() && super.placeBlock(context, state);
    }

    @NotNull
    public String getDescriptionId() {
        return this.getOrCreateDescriptionId();
    }

    @NotNull
    protected SoundEvent getPlaceSound(@NotNull BlockState state) {
        return this.placeSound;
    }
}

