/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.attack.hitscan;

import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.human.common.gameplay.item.gun.attack.GunAttackConfig;
import com.lib.common.gameplay.util.EnchantmentUtil;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public class EntityGunHitResultHandler {
    public static void handle(GunAttackConfig gunAttackConfig, Entity hitEntity) {
        LivingEntity shooter = gunAttackConfig.shooter();
        ServerLevel level = (ServerLevel)shooter.level();
        if (shooter instanceof Player && hitEntity instanceof Player && !level.getServer().isPvpAllowed()) {
            return;
        }
        if (hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            EntityGunHitResultHandler.applyFlameEffects(gunAttackConfig, livingEntity);
        }
        int powerLevel = EnchantmentUtil.getLevel((Level)level, gunAttackConfig.gunItemStack(), (ResourceKey<Enchantment>)Enchantments.POWER);
        float damage = gunAttackConfig.fireModeConfig().damage() * (1.0f + 0.25f * (float)powerLevel);
        Registry registry = shooter.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        DamageSource damageSource = new DamageSource((Holder)registry.getHolderOrThrow(AVPDamageTypeKeys.BULLET), (Entity)shooter);
        boolean wasHurt = hitEntity.hurt(damageSource, damage);
        if (wasHurt && hitEntity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)hitEntity;
            livingEntity.invulnerableTime = 0;
            livingEntity.setLastHurtByMob(shooter);
            EntityGunHitResultHandler.applyKnockbackEffects(gunAttackConfig, livingEntity, shooter);
        }
    }

    private static void applyFlameEffects(GunAttackConfig gunAttackConfig, LivingEntity livingEntity) {
        int flameLevel = EnchantmentUtil.getLevel(livingEntity.level(), gunAttackConfig.gunItemStack(), (ResourceKey<Enchantment>)Enchantments.FLAME);
        if (flameLevel > 0) {
            livingEntity.igniteForTicks(100);
        }
    }

    private static void applyKnockbackEffects(GunAttackConfig gunAttackConfig, LivingEntity livingEntity, LivingEntity shooter) {
        int punchLevel = EnchantmentUtil.getLevel(livingEntity.level(), gunAttackConfig.gunItemStack(), (ResourceKey<Enchantment>)Enchantments.PUNCH);
        float baseKnockback = gunAttackConfig.fireModeConfig().knockback();
        if (punchLevel > 0) {
            if (baseKnockback == 0.0f) {
                baseKnockback = 0.2f;
            }
            baseKnockback *= (float)punchLevel;
        }
        livingEntity.knockback((double)baseKnockback, (double)Mth.sin((float)(shooter.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(shooter.getYRot() * ((float)Math.PI / 180)))));
    }
}

