/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.pipeline;

import com.avp.common.util.AVPPredicates;
import com.avp.common.util.GunLightUtil;
import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.human.common.gameplay.item.gun.GunConfig;
import com.human.common.gameplay.item.gun.attack.GunAttackConfig;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.human.common.gameplay.item.gun.pipeline.step.GunShootStep;
import com.human.common.gameplay.item.gun.pipeline.step.impl.CheckCooldownStep;
import com.human.common.gameplay.item.gun.pipeline.step.impl.CheckReloadingStep;
import com.human.common.gameplay.item.gun.pipeline.step.impl.CheckShootDelayStep;
import com.human.common.registry.init.HumanDataComponents;
import com.just.core.functional.option.None;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.util.EnchantmentUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;

public record GunShootContext(int currentAmmunition, FireModeConfig fireModeConfig, GunConfig gunConfig, GunItem gunItem, boolean hasInfinity, boolean isFirstTick, boolean isShooterImmortal, ItemStack itemStack, LivingEntity shooter, int tickProgress) {
    private static final List<GunShootStep> STEPS = List.of(CheckShootDelayStep.INSTANCE, CheckCooldownStep.INSTANCE, CheckReloadingStep.INSTANCE);

    public GunShootContext(LivingEntity shooter, GunItem gunItem, ItemStack itemStack, int tickProgress) {
        this((Integer)itemStack.getOrDefault(HumanDataComponents.AMMUNITION.get(), (Object)0), gunItem.getGunConfig().getDefaultFireMode(), gunItem.getGunConfig(), gunItem, EnchantmentUtil.getLevel(shooter.level(), itemStack, (ResourceKey<Enchantment>)Enchantments.INFINITY) > 0, tickProgress == 0, AVPPredicates.IS_IMMORTAL.test(shooter), itemStack, shooter, tickProgress);
    }

    public static Option<GunShootContext> create(LivingEntity shooter, ItemStack itemStack, int tickProgress) {
        None none;
        Item item = itemStack.getItem();
        if (!(item instanceof GunItem)) {
            none = Option.none();
        } else {
            GunItem gunItem = (GunItem)item;
            none = Option.some((Object)new GunShootContext(shooter, gunItem, itemStack, tickProgress));
        }
        return none;
    }

    public GunShootResult shoot() {
        for (GunShootStep step : STEPS) {
            GunShootResult result = step.apply(this);
            if (result == GunShootResult.CONTINUE) continue;
            return result;
        }
        GunAttackConfig gunAttackConfig = new GunAttackConfig(this.gunConfig, this.fireModeConfig, this.shooter, this.itemStack);
        GunShootResult result = this.fireModeConfig.gunAttackAction().shoot(gunAttackConfig);
        this.runPostEffects();
        return result;
    }

    private void runPostEffects() {
        if (this.shooter.level().isClientSide) {
            return;
        }
        GunLightUtil.spawnLightSource((Entity)this.shooter);
        this.consumeAmmunition();
        this.updateItemStackDamage();
        this.playSecondaryShootSoundEffect();
        this.playPrimaryShootSoundEffects();
        LivingEntity livingEntity = this.shooter;
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            player.getCooldowns().addCooldown((Item)this.gunItem, this.fireModeConfig.cooldownInTicks());
        }
    }

    private void consumeAmmunition() {
        if (!this.isShooterImmortal && !this.hasInfinity) {
            this.itemStack.set(HumanDataComponents.AMMUNITION.get(), (Object)Math.max(this.currentAmmunition - this.fireModeConfig.consumedAmmunitionPerShot(), 0));
        }
    }

    private void updateItemStackDamage() {
        if (!this.isShooterImmortal) {
            this.itemStack.hurtAndBreak(1, this.shooter, EquipmentSlot.MAINHAND);
        }
    }

    private void playSecondaryShootSoundEffect() {
        Level level = this.shooter.level();
        int shootDelayInTicks = this.fireModeConfig.shootDelayInTicks();
        int secondaryShootSoundFrequencyInTicks = this.fireModeConfig.secondaryShootSoundFrequencyInTicks();
        Supplier<SoundEvent> secondaryShootSoundEvent = this.fireModeConfig.secondaryShootSoundEvent();
        if (secondaryShootSoundEvent != null && (this.tickProgress == shootDelayInTicks || (this.tickProgress + shootDelayInTicks) % secondaryShootSoundFrequencyInTicks == 0)) {
            level.playSound(null, this.shooter.blockPosition(), secondaryShootSoundEvent.get(), SoundSource.PLAYERS);
        }
    }

    private void playPrimaryShootSoundEffects() {
        Level level = this.shooter.level();
        int primaryShootSoundFrequencyInTicks = this.fireModeConfig.primaryShootSoundFrequencyInTicks();
        if (primaryShootSoundFrequencyInTicks <= 0 || this.tickProgress % primaryShootSoundFrequencyInTicks == 0) {
            level.playSound(null, this.shooter.blockPosition(), this.fireModeConfig.primaryShootSoundEvent().get(), SoundSource.PLAYERS);
        }
    }
}

