/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.menu.armor_case;

import com.human.common.gameplay.menu.armor_case.ArmorCaseArmorSlot;
import com.human.common.registry.init.HumanMenuTypes;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ArmorCaseMenu
extends AbstractContainerMenu {
    private static final int ARMOR_SLOT_COUNT = 4;
    private static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    private static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    private static final int SLOT_WIDTH = 18;
    private final Container container;

    public ArmorCaseMenu(int syncID, Inventory inventory) {
        this(syncID, inventory, (Container)new SimpleContainer(4));
    }

    public ArmorCaseMenu(int syncId, Inventory playerInventory, Container container) {
        super(HumanMenuTypes.ARMOR_CASE.get(), syncId);
        this.container = container;
        container.startOpen(playerInventory.player);
        this.createSlotsForCustomInventory(container);
        this.createSlotsForPlayerInventory(playerInventory);
        this.createSlotsForPlayerHotbar(playerInventory);
    }

    @NotNull
    public ItemStack quickMoveStack(Player player, int i) {
        return ItemStack.EMPTY;
    }

    public boolean stillValid(Player player) {
        return this.container.stillValid(player);
    }

    private void createSlotsForCustomInventory(Container container) {
        int xOffset = 26;
        int yOffset = 48;
        for (int column = 0; column < 4; ++column) {
            int xPos = xOffset + column * 18 * 2;
            EquipmentSlot equipmentSlot = this.getEquipmentSlotForIndex(column);
            ArmorCaseArmorSlot slot = new ArmorCaseArmorSlot(container, equipmentSlot, column, xPos, yOffset);
            this.addSlot(slot);
        }
    }

    private EquipmentSlot getEquipmentSlotForIndex(int index) {
        return switch (index) {
            case 0 -> EquipmentSlot.HEAD;
            case 1 -> EquipmentSlot.CHEST;
            case 2 -> EquipmentSlot.LEGS;
            default -> EquipmentSlot.FEET;
        };
    }

    private void createSlotsForPlayerInventory(Inventory playerInventory) {
        int xOffset = 8;
        int yOffset = 84;
        int colCount = 9;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < colCount; ++column) {
                int slotIndex = column + row * colCount + colCount;
                int xPos = xOffset + column * 18;
                int yPos = yOffset + row * 18;
                Slot slot = new Slot((Container)playerInventory, slotIndex, xPos, yPos);
                this.addSlot(slot);
            }
        }
    }

    private void createSlotsForPlayerHotbar(Inventory playerInventory) {
        int xOffset = 8;
        int yOffset = 142;
        for (int column = 0; column < 9; ++column) {
            int xPos = column * 18;
            Slot slot = new Slot((Container)playerInventory, column, xPos + xOffset, yOffset);
            this.addSlot(slot);
        }
    }
}

