/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.power.grid;

import com.human.common.gameplay.power.PowerNode;
import com.human.common.gameplay.power.grid.PowerGrid;
import com.human.common.gameplay.power.grid.PowerGridDSU;
import com.human.common.gameplay.power.grid.PowerGridExploreUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PowerGridManager {
    private final PowerGridDSU dsu = new PowerGridDSU();
    private final Map<BlockPos, PowerGrid> grids = new HashMap<BlockPos, PowerGrid>();

    public void tick() {
        for (PowerGrid grid : this.grids.values()) {
            grid.tick();
        }
    }

    public void union(BlockPos a, BlockPos b) {
        BlockPos rootB;
        BlockPos rootA = this.dsu.find(a);
        if (rootA.equals((Object)(rootB = this.dsu.find(b)))) {
            return;
        }
        PowerGrid gridA = this.grids.computeIfAbsent(rootA, r -> new PowerGrid());
        PowerGrid gridB = this.grids.computeIfAbsent(rootB, r -> new PowerGrid());
        gridA.getProducers().forEach(gridB::add);
        gridA.getConsumers().forEach(gridB::add);
        gridA.getStores().forEach(gridB::add);
        this.grids.remove(rootA);
        this.dsu.setParent(rootA, rootB);
    }

    public void splitGrid(Level level, BlockPos removedPos) {
        BlockPos oldRoot = this.dsu.find(removedPos);
        this.dsu.remove(removedPos);
        this.grids.remove(oldRoot);
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        for (Direction dir : Direction.values()) {
            BlockPos neighbor = removedPos.relative(dir);
            if (visited.contains(neighbor) || !PowerGridExploreUtil.isConnectable(level, neighbor)) continue;
            Set<BlockPos> component = PowerGridExploreUtil.discover(level, neighbor);
            BlockPos newRoot = component.iterator().next();
            PowerGrid grid = new PowerGrid();
            this.grids.put(newRoot, grid);
            for (BlockPos pos : component) {
                this.dsu.setParent(pos, newRoot);
                visited.add(pos);
                BlockEntity blockEntity = level.getBlockEntity(pos);
                if (!(blockEntity instanceof PowerNode)) continue;
                PowerNode node = (PowerNode)blockEntity;
                grid.add(node);
            }
        }
    }

    public void registerNode(BlockPos pos, PowerNode node) {
        BlockPos root = this.dsu.find(pos);
        this.grids.computeIfAbsent(root, r -> new PowerGrid()).add(node);
    }

    public void unregisterNode(BlockPos pos, PowerNode node) {
        BlockPos root = this.dsu.find(pos);
        PowerGrid grid = this.grids.get(root);
        if (grid != null) {
            grid.remove(node);
        }
    }
}

