/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.recipe;

import com.alien.common.registry.init.item.AlienResinBlockItems;
import com.avp.common.registry.init.AVPRecipes;
import com.human.common.registry.init.item.HumanPlasticBlockItems;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class IndustrialFurnaceRecipe
extends AbstractCookingRecipe {
    public static final Map<Item, Item> MELTING_RECIPES = new HashMap<Item, Item>();
    private static final float SPEED_MULTIPLIER = 0.5f;

    private static void registerMeltingRecipe(Item input, Item output) {
        MELTING_RECIPES.put(input, output);
    }

    public IndustrialFurnaceRecipe(String group, CookingBookCategory cookingBookCategory, Ingredient ingredient, ItemStack result, float experience, int cookingTime) {
        super(AVPRecipes.INDUSTRIAL_FURNACE_RECIPE_TYPE.get(), group, cookingBookCategory, ingredient, result, experience, cookingTime);
    }

    public static IndustrialFurnaceRecipe fromItem(Item input) {
        Item output = MELTING_RECIPES.get(input);
        if (output == null) {
            return null;
        }
        int vanillaTime = 200;
        int processTime = (int)((float)vanillaTime * 0.5f);
        String recipeId = BuiltInRegistries.ITEM.getKey((Object)input).getPath() + "_to_" + BuiltInRegistries.ITEM.getKey((Object)output).getPath();
        return new IndustrialFurnaceRecipe(recipeId, IndustrialFurnaceRecipe.determineRecipeCategory(input), Ingredient.of((ItemLike[])new ItemLike[]{input}), new ItemStack((ItemLike)output), 0.1f, processTime);
    }

    private static CookingBookCategory determineRecipeCategory(Item item) {
        return CookingBookCategory.BLOCKS;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return AVPRecipes.INDUSTRIAL_FURNACE_RECIPE_SERIALIZER.get();
    }

    public boolean isSpecial() {
        return true;
    }

    static {
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.COBBLESTONE, Items.STONE);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.COBBLED_DEEPSLATE, Items.DEEPSLATE);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.WHITE_TERRACOTTA, Items.WHITE_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.ORANGE_TERRACOTTA, Items.ORANGE_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.MAGENTA_TERRACOTTA, Items.MAGENTA_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.LIGHT_BLUE_TERRACOTTA, Items.LIGHT_BLUE_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.YELLOW_TERRACOTTA, Items.YELLOW_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.LIME_TERRACOTTA, Items.LIME_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.PINK_TERRACOTTA, Items.PINK_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.GRAY_TERRACOTTA, Items.GRAY_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.LIGHT_GRAY_TERRACOTTA, Items.LIGHT_GRAY_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.CYAN_TERRACOTTA, Items.CYAN_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.PURPLE_TERRACOTTA, Items.PURPLE_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.BLUE_TERRACOTTA, Items.BLUE_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.BROWN_TERRACOTTA, Items.BROWN_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.GREEN_TERRACOTTA, Items.GREEN_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.RED_TERRACOTTA, Items.RED_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.BLACK_TERRACOTTA, Items.BLACK_GLAZED_TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.QUARTZ_BLOCK, Items.SMOOTH_QUARTZ);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.SANDSTONE, Items.SMOOTH_SANDSTONE);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.STONE, Items.SMOOTH_STONE);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.BASALT, Items.SMOOTH_BASALT);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.RED_SANDSTONE, Items.SMOOTH_RED_SANDSTONE);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.STONE_BRICKS, Items.CRACKED_STONE_BRICKS);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.DEEPSLATE_BRICKS, Items.CRACKED_DEEPSLATE_BRICKS);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.DEEPSLATE_TILES, Items.CRACKED_DEEPSLATE_TILES);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.POLISHED_BLACKSTONE_BRICKS, Items.CRACKED_POLISHED_BLACKSTONE_BRICKS);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.NETHER_BRICKS, Items.CRACKED_NETHER_BRICKS);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.WET_SPONGE, Items.SPONGE);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.SAND, Items.GLASS);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.RED_SAND, Items.GLASS);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.MUD, Items.CLAY);
        IndustrialFurnaceRecipe.registerMeltingRecipe(Items.CLAY, Items.TERRACOTTA);
        IndustrialFurnaceRecipe.registerMeltingRecipe((Item)AlienResinBlockItems.RESIN.get(), (Item)HumanPlasticBlockItems.DYE_COLOR_TO_PLASTIC.get(DyeColor.GREEN).get());
        IndustrialFurnaceRecipe.registerMeltingRecipe((Item)AlienResinBlockItems.NETHER_RESIN.get(), (Item)HumanPlasticBlockItems.DYE_COLOR_TO_PLASTIC.get(DyeColor.GREEN).get());
        IndustrialFurnaceRecipe.registerMeltingRecipe((Item)AlienResinBlockItems.IRRADIATED_RESIN.get(), (Item)HumanPlasticBlockItems.DYE_COLOR_TO_PLASTIC.get(DyeColor.GREEN).get());
        IndustrialFurnaceRecipe.registerMeltingRecipe((Item)AlienResinBlockItems.ABERRANT_RESIN.get(), (Item)HumanPlasticBlockItems.DYE_COLOR_TO_PLASTIC.get(DyeColor.GREEN).get());
    }
}

