/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.just.core.functional.option.None;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class AvoidAction<T extends PathfinderMob>
extends GOAPAction<T> {
    private static final TypedIdentifier<Path> AVOID_PATH = new TypedIdentifier("avoidPath");
    private static final TypedIdentifier<BlockPos> AVOID_PATH_TARGET_POS = new TypedIdentifier("avoidPathTargetPos");
    private final int avoidRange;
    private final float avoidSpeedModifier;

    public AvoidAction(int avoidRange, float avoidSpeedModifier) {
        this.avoidRange = avoidRange;
        this.avoidSpeedModifier = avoidSpeedModifier;
        this.addPrecondition(GOAPConstants.COMBAT_RESPONSE, GOAPExpression.equalTo(CombatResponse.flight()));
        this.addPrecondition(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, GOAPExpression.isSome());
        this.addPrecondition(GOAPConstants.IS_ATTACK_TARGET_ENTITY_IN_RANGE, GOAPExpression.isTrue());
        this.addEffect(new GOAPEffect.Value<None>(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, Option.none()));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Option targetOption = (Option)worldState.getOrDefault(GOAPConstants.NEAREST_ATTACK_TARGET_ENTITY, Option.none());
        if (targetOption.isNone()) {
            return true;
        }
        LivingEntity target = (LivingEntity)targetOption.unwrap();
        if (target.isDeadOrDying() || context.distanceToSqr((Entity)target) > (double)(this.avoidRange * this.avoidRange)) {
            return true;
        }
        this.getOrCreateAvoidPath(context, target, blackboard).ifSome(avoidPath -> context.getNavigation().moveTo(avoidPath, (double)this.avoidSpeedModifier));
        return context.getNavigation().isDone();
    }

    @Override
    public void onFinish(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        context.getNavigation().stop();
    }

    private Option<Path> getOrCreateAvoidPath(T context, LivingEntity toAvoid, GOAPBlackboard blackboard) {
        Path currentAvoidPath = blackboard.get(AVOID_PATH);
        BlockPos cachedTargetPos = blackboard.get(AVOID_PATH_TARGET_POS);
        BlockPos currentTargetPos = toAvoid.blockPosition();
        if (currentAvoidPath != null && cachedTargetPos != null && cachedTargetPos.equals((Object)currentTargetPos)) {
            return Option.some((Object)currentAvoidPath);
        }
        Vec3 vec3 = DefaultRandomPos.getPosAway(context, (int)(this.avoidRange + this.avoidRange / 2), (int)7, (Vec3)toAvoid.position());
        if (vec3 == null) {
            return Option.none();
        }
        if (toAvoid.distanceToSqr(vec3.x, vec3.y, vec3.z) < toAvoid.distanceToSqr(context)) {
            return Option.none();
        }
        Path avoidPath = context.getNavigation().createPath(vec3.x, vec3.y, vec3.z, 0);
        if (avoidPath != null) {
            blackboard.set(AVOID_PATH, avoidPath);
            blackboard.set(AVOID_PATH_TARGET_POS, currentTargetPos);
        }
        return Option.ofNullable((Object)avoidPath);
    }
}

