/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.lib.common.gameplay.entity.ai.GOAPConstants;
import com.lib.common.gameplay.entity.ai.util.CombatResponse;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class WanderToLandPosAction<T extends PathfinderMob>
extends GOAPAction<T> {
    private static final TypedIdentifier<Path> PATH = new TypedIdentifier("path");
    private final double speedMultiplier;

    public WanderToLandPosAction(double speedMultiplier) {
        this.speedMultiplier = speedMultiplier;
        this.addPrecondition(GOAPConstants.IS_BORED, GOAPExpression.isTrue());
        this.addPrecondition(GOAPConstants.COMBAT_RESPONSE, GOAPExpression.equalTo(CombatResponse.rest()));
        this.addEffect(new GOAPEffect.Value<Boolean>(GOAPConstants.IS_BORED, false));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Path path = blackboard.get(PATH);
        PathNavigation navigation = context.getNavigation();
        if (path == null) {
            Vec3 randomPosition = LandRandomPos.getPos(context, (int)10, (int)7);
            if (randomPosition == null) {
                return false;
            }
            path = navigation.createPath(randomPosition.x, randomPosition.y, randomPosition.z, 1);
            blackboard.set(PATH, path);
            navigation.moveTo(path, this.speedMultiplier);
        }
        return navigation.isDone();
    }

    @Override
    public float getCost(T context, GOAPWorldState worldState) {
        return 1.0f;
    }
}

