/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.manager;

import com.avp.common.registry.AVPDeferredHolder;
import com.lib.common.gameplay.gene.Gene;
import com.lib.common.gameplay.gene.GeneModifierKey;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.GeneRegistry;
import it.unimi.dsi.fastutil.objects.Object2DoubleArrayMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;

public class GeneMap {
    private final Set<GeneModifierKey> dirtyKeys = new HashSet<GeneModifierKey>();
    private final Map<GeneModifierKey, Double> geneMap = new Object2DoubleArrayMap();

    public boolean hasGene(AVPDeferredHolder<Gene> geneHolder) {
        return this.hasGene(geneHolder.get());
    }

    public boolean hasGene(Gene gene) {
        ResourceLocation geneResourceLocation = gene.id();
        return this.geneMap.containsKey(new GeneModifierKey(geneResourceLocation, GeneOperationType.ADDITIVE)) || this.geneMap.containsKey(new GeneModifierKey(geneResourceLocation, GeneOperationType.MULTIPLICATIVE));
    }

    public boolean hasGeneModifier(GeneModifierKey geneModifierKey) {
        return this.geneMap.containsKey(geneModifierKey);
    }

    public double getValue(Gene gene, GeneOperationType operation) {
        return this.getValueFromMap(gene, operation, this.geneMap);
    }

    public double getValue(AVPDeferredHolder<Gene> geneHolder, GeneOperationType operation) {
        return this.getValueFromMap(geneHolder, operation, this.geneMap);
    }

    public double getValue(AVPDeferredHolder<Gene> geneHolder) {
        double multiplicative = this.getValue(geneHolder, GeneOperationType.MULTIPLICATIVE);
        double additive = this.getValue(geneHolder, GeneOperationType.ADDITIVE);
        return multiplicative + additive;
    }

    public Map<GeneModifierKey, Double> getBackingMap() {
        return Collections.unmodifiableMap(this.geneMap);
    }

    public void putAll(Map<GeneModifierKey, Double> geneMap) {
        geneMap.forEach(this::add);
    }

    public void add(AVPDeferredHolder<Gene> geneHolder, GeneOperationType operation, double value) {
        this.add(geneHolder.get().id(), operation, value);
    }

    public void add(ResourceLocation resourceLocation, GeneOperationType operation, double value) {
        this.add(new GeneModifierKey(resourceLocation, operation), value);
    }

    public void add(GeneModifierKey geneModifierKey, double value) {
        this.addOrInsert(geneModifierKey, value, this.geneMap);
    }

    private void addOrInsert(GeneModifierKey geneModifierKey, double additiveValue, Map<GeneModifierKey, Double> geneMap) {
        boolean valueDidChange;
        Gene gene = GeneRegistry.getValueOrNull(geneModifierKey.resourceLocation());
        if (gene == null) {
            return;
        }
        Double oldValue = geneMap.get(geneModifierKey);
        double oldValueNotNull = oldValue == null ? 0.0 : oldValue;
        Double newValue = (Double)gene.transformer().apply((Object)(oldValueNotNull + additiveValue), (Object)geneModifierKey.operation());
        geneMap.put(geneModifierKey, newValue);
        boolean bl = valueDidChange = !Objects.equals(oldValue, newValue);
        if (valueDidChange) {
            this.dirtyKeys.add(geneModifierKey);
        }
    }

    private double getValueFromMap(AVPDeferredHolder<Gene> geneHolder, GeneOperationType operation, Map<GeneModifierKey, Double> geneMap) {
        return this.getValueFromMap(geneHolder.get(), operation, geneMap);
    }

    private double getValueFromMap(Gene gene, GeneOperationType operation, Map<GeneModifierKey, Double> geneMap) {
        return geneMap.getOrDefault(new GeneModifierKey(gene.id(), operation), 0.0);
    }

    public void clear() {
        this.setDirty();
        this.geneMap.clear();
    }

    public Set<GeneModifierKey> getDirtyKeys() {
        return Collections.unmodifiableSet(this.dirtyKeys);
    }

    public void clearDirtyKeys() {
        this.dirtyKeys.clear();
    }

    public boolean isDirty() {
        return !this.dirtyKeys.isEmpty();
    }

    public void setDirty() {
        this.dirtyKeys.addAll(this.geneMap.keySet());
    }
}

