/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.manager;

import java.util.function.BiConsumer;
import mod.azure.azurelib.common.api.common.entities.AzureVibrationUser;
import mod.azure.azurelib.common.api.common.interfaces.AzureTicker;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.vibrations.VibrationSystem;
import org.jetbrains.annotations.NotNull;

public class VibrationSystemManager
implements VibrationSystem {
    private final Mob mob;
    private final VibrationSystem.Data vibrationData;
    private final AzureVibrationUser vibrationUser;
    private final DynamicGameEventListener<VibrationSystem.Listener> dynamicGameEventListener = new DynamicGameEventListener((GameEventListener)new VibrationSystem.Listener((VibrationSystem)this));

    public VibrationSystemManager(Mob mob, float speed, int range) {
        this.mob = mob;
        this.vibrationUser = new AzureVibrationUser(mob, speed, range);
        this.vibrationData = new VibrationSystem.Data();
    }

    public void tick() {
        AzureTicker.tick((Level)this.mob.level(), (VibrationSystem.Data)this.vibrationData, (VibrationSystem.User)this.vibrationUser);
    }

    public void updateDynamicGameEventListener(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> biConsumer) {
        Level level = this.mob.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            biConsumer.accept(this.dynamicGameEventListener, serverLevel);
        }
    }

    @NotNull
    public VibrationSystem.Data getVibrationData() {
        return this.vibrationData;
    }

    @NotNull
    public VibrationSystem.User getVibrationUser() {
        return this.vibrationUser;
    }
}

