/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.util;

import com.just.core.functional.option.Option;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;

public class ItemUtil {
    public static Option<ItemEntity> drop(LivingEntity livingEntity, ItemStack itemStackToDrop, boolean dropAround, boolean includeThrowerName) {
        if (itemStackToDrop.isEmpty()) {
            return Option.none();
        }
        if (livingEntity.level().isClientSide) {
            livingEntity.swing(InteractionHand.MAIN_HAND);
        }
        double d = livingEntity.getEyeY() - (double)0.3f;
        ItemEntity itemEntity = new ItemEntity(livingEntity.level(), livingEntity.getX(), d, livingEntity.getZ(), itemStackToDrop);
        itemEntity.setPickUpDelay(40);
        if (includeThrowerName) {
            itemEntity.setThrower((Entity)livingEntity);
        }
        if (dropAround) {
            float f = livingEntity.getRandom().nextFloat() * 0.5f;
            float g = livingEntity.getRandom().nextFloat() * ((float)Math.PI * 2);
            itemEntity.setDeltaMovement((double)(-Mth.sin((float)g) * f), (double)0.2f, (double)(Mth.cos((float)g) * f));
        } else {
            float g = Mth.sin((float)(livingEntity.getXRot() * ((float)Math.PI / 180)));
            float h = Mth.cos((float)(livingEntity.getXRot() * ((float)Math.PI / 180)));
            float i = Mth.sin((float)(livingEntity.getYRot() * ((float)Math.PI / 180)));
            float j = Mth.cos((float)(livingEntity.getYRot() * ((float)Math.PI / 180)));
            float k = livingEntity.getRandom().nextFloat() * ((float)Math.PI * 2);
            float l = 0.02f * livingEntity.getRandom().nextFloat();
            itemEntity.setDeltaMovement((double)(-i * h * 0.3f) + Math.cos(k) * (double)l, (double)(-g * 0.3f + 0.1f + (livingEntity.getRandom().nextFloat() - livingEntity.getRandom().nextFloat()) * 0.1f), (double)(j * h * 0.3f) + Math.sin(k) * (double)l);
        }
        return Option.some((Object)itemEntity);
    }
}

