/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util;

import com.avp.AVP;
import com.lib.common.gameplay.entity.manager.GeneMap;
import com.lib.common.gameplay.gene.GeneBonusDataEntry;
import com.lib.common.gameplay.gene.GeneModifierKey;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import org.slf4j.Logger;

public class GeneSerializationUtil {
    public static void loadGeneModifiers(String geneListKey, CompoundTag compoundTag, GeneMap geneMap) {
        if (compoundTag.contains(geneListKey, 9)) {
            ListTag listTag = compoundTag.getList(geneListKey, 10);
            for (int i = 0; i < listTag.size(); ++i) {
                CompoundTag elementTag = listTag.getCompound(i);
                GeneBonusDataEntry.CODEC.parse(new Dynamic((DynamicOps)NbtOps.INSTANCE, (Object)elementTag)).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(entry -> geneMap.add(new GeneModifierKey(entry.id(), entry.operation()), entry.value()));
            }
        }
    }

    public static void saveGeneModifiers(String geneListKey, CompoundTag compoundTag, GeneMap geneMap) {
        ListTag listTag = new ListTag();
        for (Map.Entry<GeneModifierKey, Double> entry : geneMap.getBackingMap().entrySet()) {
            GeneBonusDataEntry geneEntry = new GeneBonusDataEntry(entry.getKey().resourceLocation(), entry.getKey().operation(), entry.getValue());
            GeneBonusDataEntry.CODEC.encodeStart((DynamicOps)NbtOps.INSTANCE, (Object)geneEntry).resultOrPartial(arg_0 -> ((Logger)AVP.LOGGER).error(arg_0)).ifPresent(arg_0 -> listTag.add(arg_0));
        }
        compoundTag.put(geneListKey, (Tag)listTag);
    }
}

