/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util.codec.stream.impl;

import com.avp.common.model.DataComponentPatchAccessor;
import com.avp.mixin.MixinDataComponentPatch;
import com.just.codec.stream.StreamCodec;
import com.just.codec.stream.impl.StreamCodecs;
import com.just.codec.stream.schema.StreamCodecSchema;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MojangStreamCodecs {
    public static final StreamCodec<BlockPos> BLOCK_POS = new StreamCodec<BlockPos>(){

        @NotNull
        public <T> BlockPos decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            return BlockPos.of((long)streamCodecSchema.readLong(input));
        }

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull BlockPos value) {
            streamCodecSchema.writeLong(input, value.asLong());
        }
    };
    public static final StreamCodec<DataComponentPatch> DATA_COMPONENT_PATCH = new StreamCodec<DataComponentPatch>(){

        public <T> void encode(@NotNull StreamCodecSchema<T> schema, @NotNull T input, @NotNull DataComponentPatch patch) {
            if (patch.isEmpty()) {
                schema.writeInt(input, 0);
                schema.writeInt(input, 0);
                return;
            }
            ArrayList<Reference2ObjectMap.Entry> present = new ArrayList<Reference2ObjectMap.Entry>();
            ArrayList<DataComponentType> removed = new ArrayList<DataComponentType>();
            Reference2ObjectMap<DataComponentType<?>, Optional<?>> map = ((DataComponentPatchAccessor)patch).avp$getMap();
            for (Reference2ObjectMap.Entry entry : map.reference2ObjectEntrySet()) {
                if (((Optional)entry.getValue()).isPresent()) {
                    present.add(entry);
                    continue;
                }
                removed.add((DataComponentType)entry.getKey());
            }
            schema.writeInt(input, present.size());
            schema.writeInt(input, removed.size());
            for (Map.Entry entry : present) {
                DataComponentType type = (DataComponentType)entry.getKey();
                Object value = ((Optional)entry.getValue()).orElseThrow();
                schema.write(input, DATA_COMPONENT_TYPE, (Object)type);
                2.encodeComponent(input, type, value);
            }
            for (DataComponentType dataComponentType : removed) {
                schema.write(input, DATA_COMPONENT_TYPE, (Object)dataComponentType);
            }
        }

        @NotNull
        public <T> DataComponentPatch decode(@NotNull StreamCodecSchema<T> schema, @NotNull T input) {
            DataComponentType type;
            int i;
            int presentCount = schema.readInt(input);
            int removedCount = schema.readInt(input);
            if (presentCount == 0 && removedCount == 0) {
                return DataComponentPatch.EMPTY;
            }
            Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(Math.min(presentCount + removedCount, 65536));
            for (i = 0; i < presentCount; ++i) {
                type = (DataComponentType)schema.read(input, DATA_COMPONENT_TYPE);
                Object value = 2.decodeComponent(input, type);
                map.put((Object)type, Optional.ofNullable(value));
            }
            for (i = 0; i < removedCount; ++i) {
                type = (DataComponentType)schema.read(input, DATA_COMPONENT_TYPE);
                map.put((Object)type, Optional.empty());
            }
            return MixinDataComponentPatch.avp$construct(map);
        }

        private static <A, T> void encodeComponent(T input, DataComponentType<A> type, A value) {
            if (input instanceof RegistryFriendlyByteBuf) {
                RegistryFriendlyByteBuf byteBuf = (RegistryFriendlyByteBuf)input;
                type.streamCodec().encode((Object)byteBuf, value);
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        private static <A, T> A decodeComponent(T input, DataComponentType<A> type) {
            if (input instanceof RegistryFriendlyByteBuf) {
                RegistryFriendlyByteBuf byteBuf = (RegistryFriendlyByteBuf)input;
                return (A)type.streamCodec().decode((Object)byteBuf);
            }
            return null;
        }
    };
    public static final StreamCodec<DataComponentType<?>> DATA_COMPONENT_TYPE = new StreamCodec<DataComponentType<?>>(){

        @NotNull
        public <T> DataComponentType<?> decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            int typeId = streamCodecSchema.readVarInt(input);
            return (DataComponentType)BuiltInRegistries.DATA_COMPONENT_TYPE.byIdOrThrow(typeId);
        }

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull DataComponentType<?> value) {
            int typeId = BuiltInRegistries.DATA_COMPONENT_TYPE.getIdOrThrow(value);
            streamCodecSchema.writeVarInt(input, typeId);
        }
    };
    public static final StreamCodec<Direction> DIRECTION = new StreamCodec<Direction>(){

        @NotNull
        public <T> Direction decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            return Direction.from3DDataValue((int)streamCodecSchema.readByte(input));
        }

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull Direction value) {
            streamCodecSchema.writeByte(input, (byte)value.get3DDataValue());
        }
    };
    public static final StreamCodec<ItemStack> ITEM_STACK = new StreamCodec<ItemStack>(){

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull ItemStack value) {
            if (value.isEmpty()) {
                streamCodecSchema.writeVarInt(input, 0);
            } else {
                streamCodecSchema.writeVarInt(input, value.getCount());
                int itemId = BuiltInRegistries.ITEM.getIdOrThrow((Object)value.getItem());
                streamCodecSchema.writeVarInt(input, itemId);
                streamCodecSchema.write(input, DATA_COMPONENT_PATCH, (Object)value.getComponentsPatch());
            }
        }

        @NotNull
        public <T> ItemStack decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            int size = streamCodecSchema.readVarInt(input);
            if (size <= 0) {
                return ItemStack.EMPTY;
            }
            Holder itemHolder = (Holder)BuiltInRegistries.ITEM.asHolderIdMap().byIdOrThrow(streamCodecSchema.readVarInt(input));
            DataComponentPatch datacomponentpatch = (DataComponentPatch)DATA_COMPONENT_PATCH.decode(streamCodecSchema, input);
            return new ItemStack(itemHolder, size, datacomponentpatch);
        }
    };
    public static final StreamCodec<ResourceLocation> RESOURCE_LOCATION = new StreamCodec<ResourceLocation>(){

        @NotNull
        public <T> ResourceLocation decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            return ResourceLocation.parse((String)((String)streamCodecSchema.read(input, StreamCodecs.STRING_UTF8)));
        }

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull ResourceLocation value) {
            streamCodecSchema.write(input, StreamCodecs.STRING_UTF8, (Object)value.toString());
        }
    };
}

