/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.data;

import com.alien.common.gameplay.entity.acid.Acid;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.registry.init.AlienGameEvents;
import com.alien.common.registry.init.AlienItems;
import com.alien.common.registry.init.block.AlienResinBlocks;
import com.avp.common.registry.init.AlienParticleTypes;
import com.avp.common.registry.tag.AVPBlockTags;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.just.core.functional.option.Option;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1259;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_156;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class AlienVariantTypes {
    public static final AlienVariantType ABERRANT = new AlienVariantType(AlienVariant.ABERRANT, AlienResinBlocks.ABERRANT_RESIN, AlienResinBlocks.ABERRANT_RESIN_NODE, AlienResinBlocks.ABERRANT_RESIN_VEIN, AlienResinBlocks.ABERRANT_RESIN_VENT, AlienResinBlocks.ABERRANT_RESIN_WEB, AVPBlockTags.ABERRANT_RESIN, AVPBlockTags.ABERRANT_RESIN_REPLACEABLE, AlienItems.ABERRANT_CHITIN, AlienItems.PLATED_ABERRANT_CHITIN, AlienItems.ABERRANT_RESIN_BALL, AlienGameEvents.XENOMORPH_ABERRANT_CRY_FOR_HELP, AlienGameEvents.EGG_ABERRANT_PICKUP_REQUEST, AlienGameEvents.XENOMORPH_ABERRANT_RESIN_SPREAD, AlienParticleTypes.ACID, class_1259.class_1260.field_5782, class_124.field_1054, true);
    public static final AlienVariantType IRRADIATED = new AlienVariantType(AlienVariant.IRRADIATED, AlienResinBlocks.IRRADIATED_RESIN, AlienResinBlocks.IRRADIATED_RESIN_NODE, AlienResinBlocks.IRRADIATED_RESIN_VEIN, AlienResinBlocks.IRRADIATED_RESIN_VENT, AlienResinBlocks.IRRADIATED_RESIN_WEB, AVPBlockTags.IRRADIATED_RESIN, AVPBlockTags.IRRADIATED_RESIN_REPLACEABLE, AlienItems.IRRADIATED_CHITIN, AlienItems.PLATED_IRRADIATED_CHITIN, AlienItems.IRRADIATED_RESIN_BALL, AlienGameEvents.XENOMORPH_IRRADIATED_CRY_FOR_HELP, null, AlienGameEvents.XENOMORPH_IRRADIATED_RESIN_SPREAD, AlienParticleTypes.IRRADIATED_ACID, class_1259.class_1260.field_5780, class_124.field_1078, false);
    public static final AlienVariantType NETHER = new AlienVariantType(AlienVariant.NETHER, AlienResinBlocks.NETHER_RESIN, AlienResinBlocks.NETHER_RESIN_NODE, AlienResinBlocks.NETHER_RESIN_VEIN, AlienResinBlocks.NETHER_RESIN_VENT, AlienResinBlocks.NETHER_RESIN_WEB, AVPBlockTags.NETHER_RESIN, AVPBlockTags.NETHER_RESIN_REPLACEABLE, AlienItems.NETHER_CHITIN, AlienItems.PLATED_NETHER_CHITIN, AlienItems.NETHER_RESIN_BALL, AlienGameEvents.XENOMORPH_NETHER_CRY_FOR_HELP, AlienGameEvents.EGG_NETHER_PICKUP_REQUEST, AlienGameEvents.XENOMORPH_NETHER_RESIN_SPREAD, AlienParticleTypes.BLUE_ACID, class_1259.class_1260.field_5784, class_124.field_1061, true);
    public static final AlienVariantType NORMAL = new AlienVariantType(AlienVariant.NORMAL, AlienResinBlocks.RESIN, AlienResinBlocks.RESIN_NODE, AlienResinBlocks.RESIN_VEIN, AlienResinBlocks.RESIN_VENT, AlienResinBlocks.RESIN_WEB, AVPBlockTags.NORMAL_RESIN, AVPBlockTags.NORMAL_RESIN_REPLACEABLE, AlienItems.CHITIN, AlienItems.PLATED_CHITIN, AlienItems.RESIN_BALL, AlienGameEvents.XENOMORPH_CRY_FOR_HELP, AlienGameEvents.EGG_PICKUP_REQUEST, AlienGameEvents.XENOMORPH_RESIN_SPREAD, AlienParticleTypes.ACID, class_1259.class_1260.field_5785, class_124.field_1060, true);
    private static final Map<AlienVariant, AlienVariantType> TYPE_BY_VARIANT = (Map)class_156.method_656(() -> {
        EnumMap<AlienVariant, AlienVariantType> map = new EnumMap<AlienVariant, AlienVariantType>(AlienVariant.class);
        map.put(AlienVariant.ABERRANT, ABERRANT);
        map.put(AlienVariant.IRRADIATED, IRRADIATED);
        map.put(AlienVariant.NETHER, NETHER);
        map.put(AlienVariant.NORMAL, NORMAL);
        if (!Arrays.stream(AlienVariant.values()).allMatch(map::containsKey)) {
            throw new IllegalStateException("Missing variant types from variant map.");
        }
        return map;
    });
    private static final Map<Integer, AlienVariantType> TYPE_BY_ID = TYPE_BY_VARIANT.entrySet().stream().collect(Collectors.toMap(entry -> ((AlienVariant)((Object)((Object)entry.getKey()))).getId(), Map.Entry::getValue));

    public static AlienVariantType getFor(AlienVariant alienVariant) {
        return TYPE_BY_VARIANT.get((Object)alienVariant);
    }

    public static Option<AlienVariantType> getFor(Integer alienVariantId) {
        return Option.ofNullable((Object)TYPE_BY_ID.get(alienVariantId));
    }

    public static Option<AlienVariantType> getFor(class_2248 block) {
        return Option.ofNullable((Object)AlienVariantTypes.getForOrNull(block));
    }

    @Nullable
    public static AlienVariantType getForOrNull(class_2248 block) {
        return AlienVariantTypes.getForOrNull(block.method_9564());
    }

    public static Option<AlienVariantType> getFor(class_2680 blockState) {
        return Option.ofNullable((Object)AlienVariantTypes.getForOrNull(blockState));
    }

    @Nullable
    public static AlienVariantType getForOrNull(class_2680 blockState) {
        if (blockState.method_26164(AVPBlockTags.ABERRANT_RESIN)) {
            return ABERRANT;
        }
        if (blockState.method_26164(AVPBlockTags.IRRADIATED_RESIN)) {
            return IRRADIATED;
        }
        if (blockState.method_26164(AVPBlockTags.NETHER_RESIN)) {
            return NETHER;
        }
        if (blockState.method_26164(AVPBlockTags.RESIN)) {
            return NORMAL;
        }
        return null;
    }

    public static AlienVariantType getFor(Alien alien) {
        return AlienVariantTypes.getFor(alien.getVariant());
    }

    public static Option<AlienVariantType> getFor(class_1297 entity) {
        return Option.ofNullable((Object)AlienVariantTypes.getForOrNull(entity));
    }

    @Nullable
    public static AlienVariantType getForOrNull(class_1297 entity) {
        return AlienVariantTypes.getForOrNull(entity.method_5864());
    }

    @Deprecated(forRemoval=true)
    public static Option<AlienVariantType> getFor(Acid entity) {
        if (entity.isIrradiated()) {
            return Option.some((Object)IRRADIATED);
        }
        if (entity.isNetherAfflicted()) {
            return Option.some((Object)NETHER);
        }
        return Option.some((Object)NORMAL);
    }

    public static Option<AlienVariantType> getFor(class_1299<?> entityType) {
        return Option.ofNullable((Object)AlienVariantTypes.getForOrNull(entityType));
    }

    @Nullable
    public static AlienVariantType getForOrNull(class_1299<?> entityType) {
        if (entityType.method_20210(AVPEntityTypeTags.ABERRANT_ALIENS)) {
            return ABERRANT;
        }
        if (entityType.method_20210(AVPEntityTypeTags.IRRADIATED_ALIENS)) {
            return IRRADIATED;
        }
        if (entityType.method_20210(AVPEntityTypeTags.NETHER_ALIENS)) {
            return NETHER;
        }
        if (entityType.method_20210(AVPEntityTypeTags.NORMAL_ALIENS)) {
            return NORMAL;
        }
        return null;
    }
}

