/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.node;

import com.alien.common.gameplay.block.entity.resin.node.ChargeCursorUtil;
import com.alien.common.gameplay.block.entity.resin.node.ResinSpreader;
import com.alien.common.gameplay.block.entity.resin.node.behavior.VeinSpreadBehavior;
import com.avp.common.registry.init.AVPSoundEvents;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_5778;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ChargeCursor {
    private static final Codec<Set<class_2350>> DIRECTION_SET = class_2350.field_29502.listOf().xmap(list -> Sets.newEnumSet((Iterable)list, class_2350.class), Lists::newArrayList);
    public static final Codec<ChargeCursor> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2338.field_25064.fieldOf("pos").forGetter(ChargeCursor::getPos), (App)Codec.intRange((int)0, (int)1000).fieldOf("charge").orElse((Object)0).forGetter(ChargeCursor::getCharge), (App)Codec.intRange((int)0, (int)1).fieldOf("decay_delay").orElse((Object)1).forGetter(ChargeCursor::getDecayDelay), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).fieldOf("update_delay").orElse((Object)0).forGetter(chargeCursor -> chargeCursor.updateDelayInTicks), (App)DIRECTION_SET.lenientOptionalFieldOf("facings").forGetter(chargeCursor -> Optional.ofNullable(chargeCursor.getFacingData()))).apply((Applicative)instance, ChargeCursor::new));
    private class_2338 pos;
    int charge;
    private int updateDelayInTicks;
    private int decayDelay;
    @Nullable
    private Set<class_2350> facings;

    private ChargeCursor(class_2338 blockPos, int charge, int decayDelay, int updateDelayInTicks, Optional<Set<class_2350>> facingsOptional) {
        this.pos = blockPos;
        this.charge = charge;
        this.decayDelay = decayDelay;
        this.updateDelayInTicks = updateDelayInTicks;
        this.facings = facingsOptional.orElse(null);
    }

    public ChargeCursor(class_2338 blockPos, int i) {
        this(blockPos, i, 1, 0, Optional.empty());
    }

    public void update(class_1936 levelAccessor, class_2338 nodePos, class_5819 randomSource, ResinSpreader resinSpreader) {
        if (!this.shouldUpdate(levelAccessor, nodePos)) {
            return;
        }
        if (this.updateDelayInTicks > 0) {
            --this.updateDelayInTicks;
            return;
        }
        class_2680 blockState = levelAccessor.method_8320(this.pos);
        VeinSpreadBehavior resinBehavior = ChargeCursorUtil.getSpreadBehavior(blockState);
        if (resinBehavior.attemptSpreadVein(nodePos, levelAccessor, this.pos, blockState, this.facings)) {
            if (resinBehavior.canChangeBlockStateOnSpread()) {
                blockState = levelAccessor.method_8320(this.pos);
                resinBehavior = ChargeCursorUtil.getSpreadBehavior(blockState);
            }
            levelAccessor.method_8396(null, this.pos, AVPSoundEvents.BLOCK_RESIN_SPREAD.get(), class_3419.field_15245, 1.0f, 1.0f);
        }
        this.charge = resinBehavior.attemptUseCharge(this, levelAccessor, nodePos, randomSource, resinSpreader);
        if (this.charge > 0) {
            class_2338 validMovementPos = ChargeCursorUtil.getValidMovementPos(levelAccessor, this.pos, randomSource);
            if (validMovementPos != null) {
                this.pos = validMovementPos.method_10062();
                blockState = levelAccessor.method_8320(validMovementPos);
            }
            if (blockState.method_26204() instanceof VeinSpreadBehavior) {
                this.facings = class_5778.method_41440((class_2680)blockState);
            }
            this.decayDelay = resinBehavior.updateDecayDelay(this.decayDelay);
            this.updateDelayInTicks = resinBehavior.getResinSpreadDelayInTicks();
        }
    }

    private boolean shouldUpdate(class_1936 levelAccessor, class_2338 blockPos) {
        class_3218 serverLevel;
        return this.charge > 0 && levelAccessor instanceof class_3218 && (serverLevel = (class_3218)levelAccessor).method_41411(blockPos);
    }

    void mergeWith(ChargeCursor chargeCursor) {
        this.charge += chargeCursor.charge;
        chargeCursor.charge = 0;
        this.updateDelayInTicks = Math.min(this.updateDelayInTicks, chargeCursor.updateDelayInTicks);
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public int getCharge() {
        return this.charge;
    }

    public int getDecayDelay() {
        return this.decayDelay;
    }

    @Nullable
    public Set<class_2350> getFacingData() {
        return this.facings;
    }
}

