/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.block.entity.resin.node;

import com.alien.common.gameplay.block.entity.resin.node.behavior.ResinVeinSpreadBehavior;
import com.alien.common.gameplay.block.entity.resin.node.behavior.VeinSpreadBehavior;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_7130;
import org.jetbrains.annotations.Nullable;

public class ChargeCursorUtil {
    private static final class_2338 BOTTOM_LEFT = new class_2338(-1, -1, -1);
    private static final class_2338 TOP_RIGHT = new class_2338(1, 1, 1);
    private static final ObjectArrayList<class_2382> NON_CORNER_NEIGHBOURS = (ObjectArrayList)class_156.method_654((Object)new ObjectArrayList(18), objectArrayList -> class_2338.method_20437((class_2338)BOTTOM_LEFT, (class_2338)TOP_RIGHT).filter(ChargeCursorUtil::isZeroAxis).map(class_2338::method_10062).forEach(arg_0 -> ((ObjectArrayList)objectArrayList).add(arg_0)));

    static VeinSpreadBehavior getSpreadBehavior(class_2680 blockState) {
        VeinSpreadBehavior veinSpreadBehavior;
        class_2248 class_22482 = blockState.method_26204();
        if (class_22482 instanceof VeinSpreadBehavior) {
            VeinSpreadBehavior veinSpreadBehavior2 = (VeinSpreadBehavior)class_22482;
            veinSpreadBehavior = veinSpreadBehavior2;
        } else {
            veinSpreadBehavior = ResinVeinSpreadBehavior.INSTANCE;
        }
        return veinSpreadBehavior;
    }

    @Nullable
    static class_2338 getValidMovementPos(class_1936 levelAccessor, class_2338 blockPos, class_5819 randomSource) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        class_2338.class_2339 mutableBlockPos2 = blockPos.method_25503();
        for (class_2382 vec3i : ChargeCursorUtil.getRandomizedNonCornerNeighbourOffsets(randomSource)) {
            mutableBlockPos2.method_35831((class_2382)blockPos, vec3i);
            class_2680 blockState = levelAccessor.method_8320((class_2338)mutableBlockPos2);
            if (!(blockState.method_26204() instanceof VeinSpreadBehavior) || !ChargeCursorUtil.isMovementUnobstructed(levelAccessor, blockPos, (class_2338)mutableBlockPos2)) continue;
            mutableBlockPos.method_10101((class_2382)mutableBlockPos2);
            if (!class_7130.method_41513((class_1936)levelAccessor, (class_2680)blockState, (class_2338)mutableBlockPos2)) continue;
            break;
        }
        return mutableBlockPos.equals((Object)blockPos) ? null : mutableBlockPos;
    }

    private static boolean isZeroAxis(class_2338 blockPos) {
        return (blockPos.method_10263() == 0 || blockPos.method_10264() == 0 || blockPos.method_10260() == 0) && !blockPos.equals((Object)class_2338.field_10980);
    }

    private static List<class_2382> getRandomizedNonCornerNeighbourOffsets(class_5819 randomSource) {
        return class_156.method_43027(NON_CORNER_NEIGHBOURS, (class_5819)randomSource);
    }

    private static boolean isMovementUnobstructed(class_1936 levelAccessor, class_2338 blockPos, class_2338 blockPos2) {
        if (blockPos.method_19455((class_2382)blockPos2) == 1) {
            return true;
        }
        class_2338 blockPos3 = blockPos2.method_10059((class_2382)blockPos);
        class_2350 direction = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11048, (class_2350.class_2352)(blockPos3.method_10263() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
        class_2350 direction2 = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11052, (class_2350.class_2352)(blockPos3.method_10264() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
        class_2350 direction3 = class_2350.method_10169((class_2350.class_2351)class_2350.class_2351.field_11051, (class_2350.class_2352)(blockPos3.method_10260() < 0 ? class_2350.class_2352.field_11060 : class_2350.class_2352.field_11056));
        if (blockPos3.method_10263() == 0) {
            return ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction2) || ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction3);
        }
        return blockPos3.method_10264() == 0 ? ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction) || ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction3) : ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction) || ChargeCursorUtil.isUnobstructed(levelAccessor, blockPos, direction2);
    }

    private static boolean isUnobstructed(class_1936 levelAccessor, class_2338 blockPos, class_2350 direction) {
        class_2338 relativePos = blockPos.method_10093(direction);
        class_2350 opposite = direction.method_10153();
        class_2680 blockState = levelAccessor.method_8320(relativePos);
        return !blockState.method_26206((class_1922)levelAccessor, relativePos, opposite);
    }
}

