/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.ovomorph;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.ovomorph.HatchManager;
import com.alien.common.gameplay.entity.living.alien.ovomorph.OvomorphAnimationDispatcher;
import com.alien.common.gameplay.entity.living.alien.ovomorph.ai.OvomorphGOAP;
import com.alien.common.model.alien.HatchState;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.alien.variant.AlienVariantType;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.AVP;
import com.avp.common.registry.AVPDeferredHolder;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.registry.init.AVPSoundEvents;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.manager.VibrationSystemManager;
import com.lib.common.network.DataAccessor;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5132;
import net.minecraft.class_5147;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Ovomorph
extends Alien
implements class_5147 {
    public static final HatchState DEFAULT_HATCH_STATE = HatchState.SLEEPING;
    public final DataAccessor<Byte> hatchStateId = new DataAccessor<Byte>(this, AVPDataKeys.OVOMORPH_HATCH_STATE);
    public final DataAccessor<Byte> maxSpawnCount = new DataAccessor<Byte>(this, AVPDataKeys.OVOMORPH_MAXIMUM_SPAWN_COUNT);
    public final DataAccessor<Boolean> isRooted = new DataAccessor<Boolean>(this, AVPDataKeys.OVOMORPH_IS_ROOTED);
    private final OvomorphAnimationDispatcher animationDispatcher = new OvomorphAnimationDispatcher(this);
    private final OvomorphGOAP goap = new OvomorphGOAP(this);
    private final HatchManager hatchManager = new HatchManager(this, 60, 60);
    public boolean pickupRequestAcknowledged;
    public boolean wantsPickup;

    public static class_5132.class_5133 createOvomorphAttributes() {
        return Ovomorph.applyFrom(AVP.config.statsConfigs.OVOMORPH_STATS, class_1588.method_26918());
    }

    public Ovomorph(class_1299<? extends Ovomorph> entityType, class_1937 level) {
        super(entityType, level);
        this.config = AVP.config.statsConfigs.OVOMORPH_STATS;
        this.wantsPickup = false;
    }

    @Override
    @Nullable
    public class_1299<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Ovomorph.getType(alienVariant, this.isRoyal());
    }

    @Override
    protected VibrationSystemManager createVibrationSystemManager() {
        return new VibrationSystemManager((class_1308)this, 2.5f, 8);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        this.hatchManager.tick();
        if (!this.method_37908().field_9236) {
            AlienVariantType alienVariantType;
            AVPDeferredHolder<class_5712> deferredHolder;
            this.goap.update(this);
            this.wantsPickup = this.canBePickedUp();
            if (!this.pickupRequestAcknowledged && this.wantsPickup && this.field_6012 % 20 == 0 && (deferredHolder = (alienVariantType = AlienVariantTypes.getFor(this)).eggPickupRequestEvent()) != null) {
                this.method_32876(deferredHolder.getHolder());
            }
            if (this.method_5765()) {
                this.pickupRequestAcknowledged = false;
            }
        }
    }

    public boolean canBeHeld() {
        return this.method_5805() && !this.method_29504() && this.isRooted.get() == false && this.getHatchState().contains((Object)HatchState.SLEEPING);
    }

    public boolean canBePickedUp() {
        return this.canBeHeld() && this.method_24828() && !this.method_5765();
    }

    public void tryHatch() {
        if (!(this.method_37908().field_9236 || this.hatchManager.isHatching() || this.hatchManager.isHatched() || this.isIrradiated())) {
            this.hatchManager.hatch();
        }
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 interactionHand) {
        if (this.method_37908().field_9236) {
            return super.method_5992(player, interactionHand);
        }
        class_1799 itemStack = player.method_5998(interactionHand);
        class_1792 resinBallItem = AlienVariantTypes.getFor(this).resinBall().get();
        if (this.isRooted.get().booleanValue() && itemStack.method_31574(class_1802.field_8868)) {
            this.method_6636(class_3419.field_15248);
            this.method_32875((class_6880)class_5712.field_28730, (class_1297)player);
            itemStack.method_7970(1, (class_1309)player, Ovomorph.method_56079((class_1268)interactionHand));
            return class_1269.field_5812;
        }
        if (!this.isRooted.get().booleanValue() && itemStack.method_31574(resinBallItem)) {
            this.method_37908().method_43129(null, (class_1297)this, AVPSoundEvents.ENTITY_OVOMORPH_ROOT.get(), class_3419.field_15248, 1.0f, 1.0f);
            this.isRooted.set(true);
            itemStack.method_57008(1, (class_1309)player);
        }
        return super.method_5992(player, interactionHand);
    }

    public void method_6636(@NotNull class_3419 soundSource) {
        this.isRooted.set(false);
        this.method_37908().method_43129(null, (class_1297)this, class_3417.field_14975, soundSource, 1.0f, 1.0f);
        this.method_37908().method_43129(null, (class_1297)this, AVPSoundEvents.ENTITY_OVOMORPH_SHEAR.get(), soundSource, 1.0f, 1.0f);
        class_1792 resinBallItem = AlienVariantTypes.getFor(this).resinBall().get();
        class_1542 itemEntity = this.method_5870((class_1935)resinBallItem, 1);
        if (itemEntity != null) {
            itemEntity.method_18799(itemEntity.method_18798().method_1031((double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(this.field_5974.method_43057() * 0.05f), (double)((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f)));
        }
    }

    public boolean method_27072() {
        return this.isRooted.get();
    }

    @Override
    public boolean method_5643(@NotNull class_1282 damageSource, float damage) {
        boolean isHurt = super.method_5643(damageSource, damage);
        if (!this.method_37908().field_9236 && isHurt && damageSource.method_5529() != null) {
            this.tryHatch();
        }
        return isHurt;
    }

    protected void method_6087(@NotNull class_1297 entity) {
        class_1657 player;
        if (entity instanceof class_1657 && ((player = (class_1657)entity).method_7337() || player.method_7325())) {
            super.method_6087(entity);
            return;
        }
        if (AVPPredicates.isFreeHost(this, entity)) {
            this.tryHatch();
        }
        if (!entity.method_5864().method_20210(AVPEntityTypeTags.ALIENS) || entity.method_5864().method_20210(AVPEntityTypeTags.OVOMORPHS)) {
            super.method_6087(entity);
        }
    }

    @Override
    protected boolean canBleedAcid() {
        return !this.hatchManager.isHatching() && !this.hatchManager.isHatched();
    }

    public boolean method_5675() {
        return this.isRooted.get() == false;
    }

    public boolean method_5810() {
        return this.isRooted.get() == false;
    }

    @Override
    public boolean method_5947() {
        if (this.hatchManager.isHatched()) {
            return super.method_5947();
        }
        return super.method_5947() || this.isRooted.get() == false;
    }

    @Override
    protected boolean canHeal() {
        return !this.hatchManager.isHatching() && !this.hatchManager.isHatched() && super.canHeal();
    }

    @Override
    protected boolean canAlienRideVehicle(@NotNull class_1297 vehicle) {
        return this.isRooted.get() == false;
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.OVOMORPH_STATS.healthRegenPerSecond;
    }

    public HatchManager getHatchManager() {
        return this.hatchManager;
    }

    public Option<HatchState> getHatchState() {
        byte id = this.hatchStateId.get();
        return Option.ofNullable((Object)((Object)HatchState.ID_TO_HATCH_STATE_MAP.get(id)));
    }

    public void setHatchState(HatchState hatchState) {
        this.hatchStateId.set((byte)hatchState.getId());
    }

    public OvomorphAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    @Nullable
    public static class_1299<? extends Ovomorph> getType(AlienVariant alienVariant, boolean isRoyal) {
        if (isRoyal) {
            return switch (alienVariant) {
                default -> throw new MatchException(null, null);
                case AlienVariant.NORMAL -> AlienEntityTypes.ROYAL_OVOMORPH.get();
                case AlienVariant.NETHER -> AlienEntityTypes.ROYAL_NETHER_OVOMORPH.get();
                case AlienVariant.ABERRANT -> AlienEntityTypes.ROYAL_ABERRANT_OVOMORPH.get();
                case AlienVariant.IRRADIATED -> null;
            };
        }
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.OVOMORPH.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_OVOMORPH.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_OVOMORPH.get();
            case AlienVariant.IRRADIATED -> null;
        };
    }
}

