/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.ovomorph.ai;

import com.alien.common.gameplay.entity.living.alien.ovomorph.Ovomorph;
import com.alien.common.gameplay.entity.living.alien.ovomorph.ai.HatchAction;
import com.alien.common.gameplay.entity.living.alien.ovomorph.ai.HatchGoal;
import com.alien.common.model.alien.HatchState;
import com.lib.common.gameplay.entity.ai.EntityGOAP;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.state.GOAPMutableWorldState;

public class OvomorphGOAP
extends EntityGOAP<Ovomorph> {
    public static final TypedIdentifier<HatchState> HATCH_STATE = new TypedIdentifier("hatchState");
    public static final TypedIdentifier<Boolean> WANTS_TO_HATCH = new TypedIdentifier("wantsToHatch");

    public OvomorphGOAP(Ovomorph ovomorph) {
        this.addBaseRoutines();
    }

    @Override
    public void update(Ovomorph context) {
        if (context.getHatchManager().isHatched()) {
            return;
        }
        super.update(context);
    }

    public void addBaseRoutines() {
        this.addSensor(this::senseHatchDesireState);
        this.addSensor(this::senseHatchState);
        this.addGoal(new HatchGoal());
        this.addAction(new HatchAction());
    }

    private void senseHatchDesireState(Ovomorph ovomorph, GOAPMutableWorldState worldState) {
        worldState.set(WANTS_TO_HATCH, ovomorph.getHatchManager().getHatchDesireManager().wantsToHatch());
    }

    private void senseHatchState(Ovomorph ovomorph, GOAPMutableWorldState worldState) {
        worldState.set(HATCH_STATE, (HatchState)((Object)ovomorph.getHatchState().unwrapOr((Object)Ovomorph.DEFAULT_HATCH_STATE)));
    }
}

