/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.parasite;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.parasite.ParasiteAttachmentManager;
import com.alien.common.model.alien.FreeMob;
import com.avp.common.registry.init.AVPDataKeys;
import com.avp.common.util.AVPPredicates;
import com.lib.common.network.DataAccessor;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2596;
import net.minecraft.class_2752;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class Parasite
extends Alien {
    public final DataAccessor<Boolean> isFertile = new DataAccessor<Boolean>(this, AVPDataKeys.PARASITE_IS_FERTILE);
    protected final ParasiteAttachmentManager attachmentManager = new ParasiteAttachmentManager(this);

    protected Parasite(class_1299<? extends Parasite> entityType, class_1937 level) {
        super(entityType, level);
        this.isFertile.onChange(this::handleFertilityChange);
        this.isFertile.onLoad(this::handleFertilityChange);
    }

    public void restoreAllGoals() {
        this.method_47825(AVPPredicates.alwaysTrue());
        this.method_5959();
    }

    @Override
    public void method_5773() {
        class_1309 currentTarget;
        super.method_5773();
        this.attachmentManager.tick();
        if (!this.method_37908().field_9236 && (currentTarget = this.method_5968()) != null && !this.isValidHost(currentTarget)) {
            this.method_5980(null);
        }
    }

    public boolean method_6121(@NotNull class_1297 entity) {
        if (this.canAttachToHost(entity)) {
            this.method_5873(entity, true);
        }
        return true;
    }

    protected boolean canAttachToHost(class_1297 entity) {
        class_1309 livingEntity;
        return entity instanceof class_1309 && this.isValidHost(livingEntity = (class_1309)entity) && !AVPPredicates.hasShield(entity) && !this.method_5765() && !this.method_5782();
    }

    protected boolean isValidHost(class_1309 target) {
        return this.isFertile.get() != false && AVPPredicates.isFreeHost(this, (class_1297)target);
    }

    public boolean method_5873(@NotNull class_1297 entity, boolean bl) {
        boolean isRiding = super.method_5873(entity, bl);
        if (isRiding) {
            this.tryUpdatePlayerRiding(entity);
        }
        return isRiding;
    }

    public void method_5848() {
        class_1309 host = this.attachmentManager.getHost();
        if (host instanceof class_1308) {
            class_1308 mob = (class_1308)host;
            ((FreeMob)mob).restoreFreedom();
        }
        super.method_5848();
        this.tryUpdatePlayerRiding((class_1297)host);
    }

    protected void method_6087(@NotNull class_1297 entity) {
        super.method_6087(entity);
        if (this.canAttachToHost(entity)) {
            this.method_5804(entity);
        }
    }

    private void tryUpdatePlayerRiding(class_1297 entity) {
        if (!this.method_37908().field_9236 && entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            player.field_13987.method_14364((class_2596)new class_2752(entity));
        }
    }

    @Override
    protected boolean canHeal() {
        return this.isFertile.get() != false && super.canHeal();
    }

    @Override
    protected boolean canBleedAcid() {
        return this.isFertile.get() != false || this.attachmentManager.isAttachedToHost();
    }

    public boolean method_5810() {
        return this.isFertile.get();
    }

    public ParasiteAttachmentManager getAttachmentManager() {
        return this.attachmentManager;
    }

    private void handleFertilityChange(Boolean isFertile) {
        if (!isFertile.booleanValue()) {
            ((FreeMob)((Object)this)).removeFreedom();
            this.method_47825(AVPPredicates.alwaysTrue());
        } else {
            ((FreeMob)((Object)this)).restoreFreedom();
            this.restoreAllGoals();
        }
    }
}

