/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.boiler;

import com.alien.common.gameplay.ai.InvestigateVibrationGoal;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.entity.living.alien.xenomorph.Xenomorph;
import com.alien.common.gameplay.entity.living.alien.xenomorph.boiler.BoilerAnimationDispatcher;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.model.resin.ResinData;
import com.alien.common.registry.init.AlienEntityTypes;
import com.alien.common.util.AcidBleedUtil;
import com.avp.AVP;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5132;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Boiler
extends Xenomorph {
    private final BoilerAnimationDispatcher animationDispatcher = new BoilerAnimationDispatcher(this);

    public static class_5132.class_5133 createBoilerAttributes() {
        return Boiler.applyFrom(AVP.config.statsConfigs.BOILER_STATS, class_1588.method_26918());
    }

    public Boiler(class_1299<? extends Boiler> entityType, class_1937 level) {
        super((class_1299<? extends Xenomorph>)entityType, level);
        this.config = AVP.config.statsConfigs.BOILER_STATS;
    }

    @Override
    @Nullable
    public class_1299<? extends Alien> getTypeForVariant(AlienVariant alienVariant) {
        return Boiler.getType(alienVariant);
    }

    @Override
    @Nullable
    protected ResinData createResinData() {
        return null;
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(3, (class_1352)new InvestigateVibrationGoal(this));
    }

    @Override
    protected boolean canTargetInitially(class_1309 target) {
        return target.method_5858((class_1297)this) <= 16.0 && super.canTargetInitially(target);
    }

    public boolean method_6121(@NotNull class_1297 entity) {
        float radius = 2.0f;
        this.method_37908().method_8437((class_1297)this, this.method_23317(), this.method_23318(), this.method_23321(), radius, class_1937.class_7867.field_40890);
        this.method_60699(class_1297.class_5529.field_26998);
        this.method_31472();
        this.getBlockArea(this.method_24515(), (int)radius, (int)radius, (int)radius).stream().filter(blockPos -> {
            class_2680 blockState = this.method_37908().method_8320(blockPos);
            return blockState.method_26215() || blockState.method_45474();
        }).forEach(blockPos -> AcidBleedUtil.spawnAcid((class_1309)this, 3.0f, blockPos.method_46558()));
        return true;
    }

    private List<class_2338> getBlockArea(class_2338 center, int radiusX, int radiusY, int radiusZ) {
        ArrayList<class_2338> positions = new ArrayList<class_2338>();
        for (int dx = -radiusX; dx <= radiusX; ++dx) {
            for (int dy = -radiusY; dy <= radiusY; ++dy) {
                for (int dz = -radiusZ; dz <= radiusZ; ++dz) {
                    positions.add(center.method_10069(dx, dy, dz));
                }
            }
        }
        return positions;
    }

    @Override
    protected void addDigToTargetGoal() {
    }

    @Override
    public void runAttackAnimations() {
    }

    @Override
    protected float getHealthRegenPerSecond() {
        return AVP.config.statsConfigs.BOILER_STATS.healthRegenPerSecond;
    }

    @Override
    public Integer getMaxJellyToGrowth() {
        return null;
    }

    public BoilerAnimationDispatcher getAnimationDispatcher() {
        return this.animationDispatcher;
    }

    public static class_1299<? extends Alien> getType(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> AlienEntityTypes.BOILER.get();
            case AlienVariant.NETHER -> AlienEntityTypes.NETHER_BOILER.get();
            case AlienVariant.ABERRANT -> AlienEntityTypes.ABERRANT_BOILER.get();
            case AlienVariant.IRRADIATED -> null;
        };
    }
}

