/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.living.alien.xenomorph.queen;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.ovipositor.Ovipositor;
import com.alien.common.gameplay.entity.living.alien.xenomorph.queen.Queen;
import com.alien.common.registry.init.AlienEntityTypes;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.EntityUtil;
import com.just.core.functional.option.Option;
import com.lib.common.data.Cooldown;
import com.lib.common.gameplay.NBTSerializable;
import java.time.Duration;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class OvipositorManager
implements NBTSerializable {
    private final Cooldown ovipositorCreationCooldown = Cooldown.withCooldownTime("ovipositorCreationCooldownInTicks", Duration.ofMinutes(1L));
    private final Queen queen;
    private boolean hadOvipositorLastTick;

    public OvipositorManager(Queen queen) {
        this.queen = queen;
    }

    public void tick() {
        if (this.queen.method_37908().field_9236) {
            return;
        }
        this.ovipositorCreationCooldown.tick();
        boolean hasOvipositor = this.hasOvipositor();
        if (!hasOvipositor && this.hadOvipositorLastTick) {
            this.ovipositorCreationCooldown.reset();
        }
        this.hadOvipositorLastTick = hasOvipositor;
        if (hasOvipositor) {
            this.getOvipositor().ifSome(ovipositor -> {
                ovipositor.method_36456(this.queen.method_36454());
                ovipositor.method_36457(this.queen.method_36455());
                ovipositor.field_6283 = this.queen.field_6283;
                ovipositor.field_6241 = this.queen.field_6241;
            });
            return;
        }
        if (!this.canCreateOvipositor()) {
            return;
        }
        this.createOvipositor();
        this.ovipositorCreationCooldown.reset();
    }

    public class_243 getEggLayingPosition() {
        return EntityUtil.getRelativePosition((class_1309)this.queen, 6.0, 0.0, 2.5);
    }

    @Nullable
    public Ovipositor getOvipositorOrNull() {
        return this.queen.method_5685().stream().filter(passenger -> passenger.method_5864() == AlienEntityTypes.OVIPOSITOR.get()).findFirst().orElse(null);
    }

    public Option<Ovipositor> getOvipositor() {
        return Option.ofNullable((Object)((Object)this.getOvipositorOrNull()));
    }

    public boolean hasOvipositor() {
        return this.getOvipositorOrNull() != null;
    }

    private void createOvipositor() {
        Ovipositor ovipositor = (Ovipositor)AlienEntityTypes.OVIPOSITOR.get().method_5883(this.queen.method_37908());
        if (ovipositor != null) {
            ovipositor.method_60949(this.queen.method_19538(), this.queen.method_36454(), this.queen.method_36455());
            ovipositor.method_5873((class_1297)this.queen, true);
            ovipositor.field_6283 = this.queen.field_6283;
            ovipositor.field_6241 = this.queen.field_6241;
            this.queen.method_37908().method_8649((class_1297)ovipositor);
        }
    }

    private boolean canCreateOvipositor() {
        return this.queen.method_5968() == null && AlienVariantTypes.getFor(this.queen.getVariant()).canReproduce() && !this.queen.isPoisoned() && !this.ovipositorCreationCooldown.isActive() && this.queen.getHiveManager().hive().isSomeAnd(hive -> hive.isAlive() && !hive.isAngry() && hive.getMembershipManager().getMembersMatching(entityType -> entityType.method_20210(AVPEntityTypeTags.XENOMORPHS)).size() > 2) && this.canOvipositorFit();
    }

    private boolean canOvipositorFit() {
        class_243 leftBottomSupport = EntityUtil.getRelativePosition((class_1309)this.queen, 1.5, 0.0, 2.5);
        class_243 rightBottomSupport = EntityUtil.getRelativePosition((class_1309)this.queen, -2.0, 0.0, 2.0);
        class_243 farLeftBottomSupport = EntityUtil.getRelativePosition((class_1309)this.queen, 5.7, 0.0, 8.25);
        class_243 backBottomSupport = EntityUtil.getRelativePosition((class_1309)this.queen, 0.0, 0.0, 7.0);
        return this.canOvipositorSupportExistAt(leftBottomSupport) && this.canOvipositorSupportExistAt(rightBottomSupport) && this.canOvipositorSupportExistAt(farLeftBottomSupport) && this.canOvipositorSupportExistAt(backBottomSupport) && this.isEggLayingPositionValid();
    }

    private boolean isEggLayingPositionValid() {
        class_243 eggLayingPosition = this.getEggLayingPosition();
        class_2680 blockState = this.queen.method_37908().method_8320(class_2338.method_49638((class_2374)eggLayingPosition));
        boolean isClearForEgg = blockState.method_26215() || blockState.method_45474();
        return isClearForEgg && EntityUtil.canMobSeeBlock((class_1308)this.queen, eggLayingPosition);
    }

    private boolean canOvipositorSupportExistAt(class_243 vec3) {
        class_2338 blockPos = class_2338.method_49638((class_2374)vec3);
        boolean isSupported = false;
        for (int stepsDown = 0; !isSupported && stepsDown < 4; ++stepsDown) {
            blockPos = blockPos.method_10074();
            class_2680 blockState = this.queen.method_37908().method_8320(blockPos);
            class_2680 aboveBlockState = this.queen.method_37908().method_8320(blockPos.method_10084());
            isSupported = (aboveBlockState.method_26215() || aboveBlockState.method_45474()) && !blockState.method_26215() && !blockState.method_45474();
        }
        return isSupported && EntityUtil.canMobSeeBlock((class_1308)this.queen, vec3);
    }

    @Override
    public void load(class_2487 compoundTag) {
        this.ovipositorCreationCooldown.load(compoundTag);
    }

    @Override
    public void save(class_2487 compoundTag) {
        this.ovipositorCreationCooldown.save(compoundTag);
    }
}

