/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.hive.membership;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.gameplay.hive.Hive;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.util.CompoundTagUtil;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HiveLeadershipManager
implements NBTSerializable {
    private static final String LEADER_ID_KEY = "HiveLeaderId";
    private final Hive hive;
    private Option<UUID> leaderIdOption;

    public HiveLeadershipManager(Hive hive) {
        this.hive = hive;
        this.leaderIdOption = Option.none();
    }

    public void tick() {
        if (!this.hive.getMembershipManager().isMember(this.getLeaderIdOrNull())) {
            this.setLeaderId(null);
        }
    }

    public void removeLeadership(@NotNull class_1297 entity) {
        this.removeLeadership(entity.method_5667());
    }

    public void removeLeadership(@NotNull UUID uuid) {
        if (this.leaderIdOption.contains((Object)uuid)) {
            this.leaderIdOption = Option.none();
        }
    }

    public boolean isLeader(class_1297 entity) {
        return this.leaderIdOption.contains((Object)entity.method_5667());
    }

    @Nullable
    public UUID getLeaderIdOrNull() {
        return (UUID)this.leaderIdOption.unwrapOr(null);
    }

    public Option<Alien> getLeader() {
        return Option.ofNullable((Object)this.getLeaderOrNull());
    }

    @Nullable
    public Alien getLeaderOrNull() {
        class_1937 class_19372 = this.hive.level();
        if (!(class_19372 instanceof class_3218)) {
            return null;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        return (Alien)this.leaderIdOption.map(arg_0 -> ((class_3218)serverLevel).method_14190(arg_0)).filter(entity -> entity instanceof Alien).map(entity -> (Alien)entity).unwrapOr(null);
    }

    public void setLeaderId(@Nullable UUID id) {
        this.leaderIdOption = Option.ofNullable((Object)id);
    }

    @Override
    public void load(class_2487 compoundTag) {
        this.leaderIdOption = Option.ofNullable((Object)CompoundTagUtil.getUUIDOrNull(compoundTag, LEADER_ID_KEY));
    }

    @Override
    public void save(class_2487 compoundTag) {
        this.leaderIdOption.ifSome(leaderId -> compoundTag.method_25927(LEADER_ID_KEY, leaderId));
    }
}

