/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.registry;

import com.alien.common.model.lifecycle.growth.GrowthStage;
import com.alien.common.model.lifecycle.growth.GrowthStageKey;
import com.just.core.functional.option.Option;
import com.lib.common.data.EntityTypePredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class GrowthStageRegistry {
    private static final List<GrowthStage> GROWTH_STAGES = new ArrayList<GrowthStage>();
    private static final Map<GrowthStageKey, GrowthStage> GROWTH_STAGE_KEY_TO_GROWTH_STAGE = new HashMap<GrowthStageKey, GrowthStage>();

    @Nullable
    public static GrowthStage getOrNull(class_1299<?> host, class_1299<?> currentForm) {
        GrowthStage directMapping = GROWTH_STAGE_KEY_TO_GROWTH_STAGE.get(new GrowthStageKey(host, currentForm));
        return directMapping == null ? GROWTH_STAGE_KEY_TO_GROWTH_STAGE.get(new GrowthStageKey(null, currentForm)) : directMapping;
    }

    public static void clear() {
        GROWTH_STAGES.clear();
    }

    public static void register(GrowthStage growthStage) {
        GROWTH_STAGES.add(growthStage);
    }

    public static void rebuildLookupMappings() {
        GROWTH_STAGE_KEY_TO_GROWTH_STAGE.clear();
        GROWTH_STAGES.forEach(GrowthStageRegistry::compute);
    }

    public static Option<GrowthStage> get(class_1299<?> host, class_1299<?> currentForm) {
        return Option.ofNullable((Object)GrowthStageRegistry.getOrNull(host, currentForm));
    }

    private static void compute(GrowthStage growthStage) {
        EntityTypePredicate hostTypePredicate = growthStage.hostTypePredicate().orElse(null);
        if (hostTypePredicate == null) {
            GrowthStageKey lookupKey = new GrowthStageKey(null, growthStage.from());
            GROWTH_STAGE_KEY_TO_GROWTH_STAGE.put(lookupKey, growthStage);
        } else {
            class_7923.field_41177.method_10220().filter(hostTypePredicate::test).forEach(entityType -> {
                GrowthStageKey lookupKey = new GrowthStageKey((class_1299<?>)entityType, growthStage.from());
                GROWTH_STAGE_KEY_TO_GROWTH_STAGE.put(lookupKey, growthStage);
            });
        }
    }
}

