/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.registry;

import com.alien.common.model.lifecycle.infection.Infection;
import com.alien.common.model.lifecycle.infection.InfectionKey;
import com.just.core.functional.option.Option;
import com.lib.common.data.EntityTypePredicate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class InfectionRegistry {
    private static final List<Infection> INFECTIONS = new ArrayList<Infection>();
    private static final Map<InfectionKey, Infection> INFECTION_KEY_TO_INFECTION = new HashMap<InfectionKey, Infection>();

    @Nullable
    public static Infection getOrNull(class_1299<?> host, class_1299<?> parasite) {
        Infection maybeInfection = INFECTION_KEY_TO_INFECTION.get(new InfectionKey(host, parasite));
        if (maybeInfection == null) {
            maybeInfection = INFECTION_KEY_TO_INFECTION.get(new InfectionKey(null, parasite));
        }
        return maybeInfection;
    }

    public static void clear() {
        INFECTIONS.clear();
    }

    public static void register(Infection infection) {
        INFECTIONS.add(infection);
    }

    public static void rebuildLookupMappings() {
        INFECTION_KEY_TO_INFECTION.clear();
        INFECTIONS.forEach(InfectionRegistry::compute);
    }

    public static Option<Infection> get(class_1299<?> host, class_1299<?> parasite) {
        return Option.ofNullable((Object)InfectionRegistry.getOrNull(host, parasite));
    }

    public static void compute(Infection infection) {
        EntityTypePredicate hostTypePredicate = infection.hostTypePredicate().orElse(null);
        if (hostTypePredicate == null) {
            InfectionKey lookupKey = new InfectionKey(null, infection.parasiteType());
            INFECTION_KEY_TO_INFECTION.put(lookupKey, infection);
        } else {
            class_7923.field_41177.method_10220().filter(hostTypePredicate::test).forEach(entityType -> {
                InfectionKey lookupKey = new InfectionKey((class_1299<?>)entityType, infection.parasiteType());
                INFECTION_KEY_TO_INFECTION.put(lookupKey, infection);
            });
        }
    }
}

