/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.util;

import com.alien.common.data.AlienVariantTypes;
import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.Host;
import com.alien.common.model.alien.variant.AlienVariant;
import com.avp.common.registry.tag.AVPBlockTags;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.util.AVPPredicates;
import com.just.core.functional.option.Option;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1548;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public class AlienPredicates {
    public static boolean canTarget(@NotNull Alien alien, @NotNull class_1309 potentialTarget) {
        return AlienPredicates.canContinueTargeting(alien, potentialTarget) && (AlienPredicates.isAlienTarget(alien, potentialTarget) || AlienPredicates.isHated(alien, potentialTarget) || AlienPredicates.isStandingOnResin(potentialTarget) || AlienPredicates.doesTargetHaveEnemyVariantEmbryo(alien.getVariant(), potentialTarget));
    }

    public static boolean canContinueTargeting(@NotNull Alien alien, @NotNull class_1309 potentialTarget) {
        Alien targetedAlien;
        return AlienPredicates.isValidTarget(alien.getVariant(), potentialTarget) && (!(potentialTarget instanceof Alien) || AlienPredicates.areAliensEnemies(alien, targetedAlien = (Alien)potentialTarget));
    }

    public static boolean isAlienTarget(@NotNull Alien alien, @NotNull class_1309 potentialTarget) {
        Alien potentialAlienTarget;
        return potentialTarget.method_5864().method_20210(AVPEntityTypeTags.ALIENS) && potentialTarget instanceof Alien && AlienPredicates.areAliensEnemies(alien, potentialAlienTarget = (Alien)potentialTarget);
    }

    public static boolean areAliensEnemies(Alien first, Alien second) {
        return AlienPredicates.areAliensDifferentStrains(first, second);
    }

    private static boolean areAliensDifferentStrains(Alien first, Alien second) {
        return !Objects.equals(first.isAberrant(), second.isAberrant()) || !Objects.equals(first.isIrradiated(), second.isIrradiated()) || !Objects.equals(first.isNetherAfflicted(), second.isNetherAfflicted());
    }

    public static boolean isValidTarget(AlienVariant selfVariant, @NotNull class_1309 potentialTarget) {
        return !(potentialTarget instanceof class_1420 || potentialTarget instanceof class_1548 || !potentialTarget.method_5805() || !potentialTarget.method_6102() || potentialTarget instanceof class_1657 && AVPPredicates.IS_IMMORTAL.test(potentialTarget) || AVPPredicates.hasEmbryo((class_1297)potentialTarget) && !AlienPredicates.doesTargetHaveEnemyVariantEmbryo(selfVariant, potentialTarget) || AVPPredicates.isParasiteAttached((class_1297)potentialTarget));
    }

    private static boolean doesTargetHaveEnemyVariantEmbryo(AlienVariant selfVariant, @NotNull class_1309 potentialTarget) {
        Host host;
        return potentialTarget instanceof Host && (host = (Host)potentialTarget).getEmbryoType().isSomeAnd(embryoType -> AlienVariantTypes.getFor(embryoType).isSomeAnd(alienVariantType -> !Objects.equals((Object)selfVariant, (Object)alienVariantType.variant())));
    }

    public static boolean isTargetingHiveMember(@NotNull Alien alien, @NotNull class_1309 potentialTarget) {
        Alien targetedAlien;
        class_1309 class_13092;
        class_1308 mob;
        return potentialTarget instanceof class_1308 && (mob = (class_1308)potentialTarget).method_5968() != null && (class_13092 = mob.method_5968()) instanceof Alien && AlienPredicates.areAliensSameHive(alien, targetedAlien = (Alien)class_13092);
    }

    public static boolean areAliensSameHive(@NotNull Alien alien, @NotNull Alien otherAlien) {
        Option<UUID> hiveSignatureOption = alien.getHiveManager().signature();
        Option<UUID> otherHiveSignatureOption = otherAlien.getHiveManager().signature();
        return hiveSignatureOption.isSome() && otherHiveSignatureOption.isSome() && Objects.equals(hiveSignatureOption, otherHiveSignatureOption);
    }

    public static boolean isStandingOnResin(@NotNull class_1309 potentialTarget) {
        class_2338 basePos = potentialTarget.method_24515();
        class_2338 belowPos = basePos.method_10074();
        class_2680 baseBlockState = potentialTarget.method_37908().method_8320(basePos);
        class_2680 belowBlockState = potentialTarget.method_37908().method_8320(belowPos);
        return baseBlockState.method_26164(AVPBlockTags.RESIN) || belowBlockState.method_26164(AVPBlockTags.RESIN);
    }

    private static boolean isHated(@NotNull Alien alien, @NotNull class_1309 potentialTarget) {
        if (AVPPredicates.IS_IMMORTAL.test(potentialTarget)) {
            return false;
        }
        return potentialTarget.method_5864().method_20210(AVPEntityTypeTags.HATED_BY_XENOMORPHS) || AlienPredicates.isTargetingHiveMember(alien, potentialTarget);
    }
}

