/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.data.worldgen.builder;

import com.avp.AVPResources;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_3124;
import net.minecraft.class_5321;
import net.minecraft.class_5450;
import net.minecraft.class_5857;
import net.minecraft.class_6661;
import net.minecraft.class_6792;
import net.minecraft.class_6793;
import net.minecraft.class_6795;
import net.minecraft.class_6796;
import net.minecraft.class_6797;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public record AVPOreData(String name, class_5321<class_2975<?, ?>> configuredFeatureKey, class_5321<class_6796> placedFeatureKey, class_3124 oreConfiguration, List<class_6797> modifiers) {
    private static final Comparator<class_6797> MODIFIER_COMPARATOR = Comparator.comparingInt(mod -> {
        class_6797 class_67972 = mod;
        Objects.requireNonNull(class_67972);
        class_6797 selector0$temp = class_67972;
        int index$1 = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_5857.class, class_5450.class, class_6795.class, class_6661.class}, (Object)selector0$temp, index$1)) {
            case 0 -> {
                class_5857 $ = (class_5857)selector0$temp;
                yield 1;
            }
            case 1 -> {
                class_5450 $ = (class_5450)selector0$temp;
                yield 2;
            }
            case 2 -> {
                class_6795 $ = (class_6795)selector0$temp;
                yield 3;
            }
            case 3 -> {
                class_6661 $ = (class_6661)selector0$temp;
                yield 4;
            }
            default -> Integer.MAX_VALUE;
        };
    });

    public class_2975<class_3124, class_3031<class_3124>> createConfiguredFeature() {
        return new class_2975(class_3031.field_13517, (class_3037)this.oreConfiguration);
    }

    public class_6796 createPlacedFeature(class_7871<class_2975<?, ?>> holder) {
        return new class_6796((class_6880)holder.method_46747(this.configuredFeatureKey), this.modifiers);
    }

    public static Builder builder(String name, class_3124.class_5876 targetBlockState) {
        return AVPOreData.builder(name, List.of(targetBlockState));
    }

    public static Builder builder(String name, List<class_3124.class_5876> targetBlockStates) {
        return new Builder(name, targetBlockStates);
    }

    public static class Builder {
        private final String name;
        private final List<class_3124.class_5876> targetBlockStates;
        private final List<class_6797> modifiers;
        private int veinSize;
        private float normalizedAirDiscardChance;

        private Builder(String name, List<class_3124.class_5876> targetBlockStates) {
            this.name = name;
            this.targetBlockStates = new ArrayList<class_3124.class_5876>(targetBlockStates);
            this.modifiers = new ArrayList<class_6797>();
            this.normalizedAirDiscardChance = 0.0f;
            this.veinSize = 9;
        }

        public Builder normalizedAirDiscardChance(float normalizedAirDiscardChance) {
            this.normalizedAirDiscardChance = normalizedAirDiscardChance;
            return this;
        }

        public Builder target(class_3124.class_5876 targetBlockState) {
            this.targetBlockStates.add(targetBlockState);
            return this;
        }

        public Builder veinSize(int veinSize) {
            this.veinSize = veinSize;
            return this;
        }

        public Builder biomeFilter(class_6792 biomeFilter) {
            this.modifiers.add((class_6797)biomeFilter);
            return this;
        }

        public Builder count(int count) {
            this.modifiers.add((class_6797)class_6793.method_39623((int)count));
            return this;
        }

        public Builder heightRange(class_6795 heightRangePlacement) {
            this.modifiers.add((class_6797)heightRangePlacement);
            return this;
        }

        public Builder spread() {
            this.modifiers.add((class_6797)class_5450.method_39639());
            return this;
        }

        public AVPOreData build() {
            class_2960 resourceLocation = AVPResources.location(this.name);
            class_5321 configuredFeatureKey = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)resourceLocation);
            class_5321 placedFeatureKey = class_5321.method_29179((class_5321)class_7924.field_41245, (class_2960)resourceLocation);
            class_3124 oreConfiguration = new class_3124(this.targetBlockStates, this.veinSize, this.normalizedAirDiscardChance);
            this.modifiers.sort(MODIFIER_COMPARATOR);
            return new AVPOreData(this.name, configuredFeatureKey, (class_5321<class_6796>)placedFeatureKey, oreConfiguration, this.modifiers);
        }
    }
}

