/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.command.nuke;

import com.avp.AVP;
import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionProgressTracker;
import com.avp.common.gameplay.explosion.nuke.NuclearExplosionEffects;
import com.avp.common.util.ExplosionUtil;
import com.avp.server.ServerScheduler;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.time.Duration;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class NukeCommand {
    private static final String COMMAND_NAME = "nuke";

    public static LiteralArgumentBuilder<class_2168> create() {
        return (LiteralArgumentBuilder)class_2170.method_9247((String)COMMAND_NAME).executes(context -> {
            ServerScheduler.schedule(() -> {
                Explosion explosion = NukeCommand.createNuclearExplosion((CommandContext<class_2168>)context);
                explosion.explode();
            }, Duration.ofSeconds(1L));
            return 1;
        });
    }

    private static Explosion createNuclearExplosion(CommandContext<class_2168> context) {
        class_3218 level = ((class_2168)context.getSource()).method_9225();
        class_243 center = ((class_2168)context.getSource()).method_9222();
        ExplosionProgressTracker progressTracker = new ExplosionProgressTracker();
        NuclearExplosionEffects nuclearExplosionEffects = new NuclearExplosionEffects();
        int radius = 128;
        int maxKnockback = 5;
        return Explosion.builder(level, center).withRadius(class_2350.class_2353.field_11062, radius).withRadius(class_2350.field_11036, radius / 2).withRadius(class_2350.field_11033, 32).onExplosionStart(() -> {
            progressTracker.startTimer();
            List<class_1297> entities = ExplosionUtil.getEntitiesInRadius(level, center, radius);
            for (class_1297 entity : entities) {
                double distance = entity.method_5707(center);
                double damage = ExplosionUtil.computeDamage(radius, 5.0, 1000.0, distance);
                entity.method_5639(15.0f);
                entity.method_5643(level.method_48963().method_48807(null), (float)damage);
                ExplosionUtil.applyKnockback(center, radius, entity, maxKnockback, distance);
            }
        }).onBlockSample(($, pos) -> {
            nuclearExplosionEffects.apply($, pos);
            progressTracker.incrementBlockDestroyCounter();
        }).onExplosionFinish(() -> {
            progressTracker.stopTimer();
            long timeTakenInMillis = progressTracker.timeTaken();
            long timeTakenInTicks = timeTakenInMillis / 50L;
            AVP.LOGGER.info("Explosion @ {} completed in {}ms ({} ticks), destroying {} blocks!", new Object[]{center, timeTakenInMillis, timeTakenInTicks, progressTracker.blocksDestroyed()});
        }).build();
    }
}

