/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.gameplay.explosion.nuke;

import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.registry.init.block.CoreBlocks;
import com.avp.common.registry.key.AVPBiomeKeys;
import com.avp.common.util.ExplosionUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2488;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_5742;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class NuclearExplosionEffects {
    private static final Map<class_2248, class_2248> BLOCK_TRANSFORMER_MAP = Map.ofEntries(Map.entry(class_2246.field_10115, class_2246.field_10255), Map.entry(class_2246.field_28888, class_2246.field_29031), Map.entry(class_2246.field_10508, class_2246.field_10102), Map.entry(class_2246.field_10474, class_2246.field_10534), Map.entry(class_2246.field_10219, class_2246.field_10253), Map.entry(class_2246.field_10164, class_2246.field_10092), Map.entry(class_2246.field_10340, class_2246.field_10445));
    private final Set<class_1923> visitedChunks = new HashSet<class_1923>();

    public void apply(Explosion explosion, class_2338 pos) {
        class_2338 centerPos = explosion.config().centerBlockPosition();
        class_3218 level = explosion.level();
        int x = pos.method_10263() - centerPos.method_10263();
        int y = pos.method_10264() - centerPos.method_10264();
        int z = pos.method_10260() - centerPos.method_10260();
        int radiusX = explosion.config().largestRadius(class_2350.class_2351.field_11048);
        int radiusZ = explosion.config().largestRadius(class_2350.class_2351.field_11051);
        int radiusYDown = explosion.config().radius(class_2350.field_11033);
        int radiusYUp = explosion.config().radius(class_2350.field_11036);
        double yScaleFactor = (double)(radiusX + radiusZ) / 2.0 / (double)Math.max(radiusYUp, radiusYDown);
        double horizontalDistance = ExplosionUtil.getNormalizedHorizontalDistance(explosion, x, z);
        double verticalDistance = ExplosionUtil.getNormalizedVerticalDistance(explosion, y) * yScaleFactor;
        double distance = horizontalDistance + verticalDistance;
        int flags = 34;
        float rand = level.field_9229.method_43057();
        class_2338 posBelow = pos.method_10074();
        class_2680 blockState = level.method_8320(pos);
        if (distance > 0.98) {
            int rand2;
            class_2248 transformedBlock = (double)rand > horizontalDistance ? class_2246.field_23869 : (blockState.method_26164(class_3481.field_29822) ? class_2246.field_22091 : (blockState.method_26164(class_3481.field_15466) || blockState.method_27852(class_2246.field_9979) || blockState.method_27852(class_2246.field_10344) ? ((rand2 = level.field_9229.method_43048(100)) < 66 ? CoreBlocks.TRINITITE_BLOCK.get() : class_2246.field_10092) : BLOCK_TRANSFORMER_MAP.getOrDefault(blockState.method_26204(), class_2246.field_22091)));
            if (blockState.method_26216((class_1922)level, pos) && level.method_8409().method_43048(10) < 2) {
                level.method_8652(pos.method_10084(), (class_2680)CoreBlocks.ASH_BLOCK.get().method_9564().method_11657((class_2769)class_2488.field_11518, (Comparable)Integer.valueOf(1)), flags);
            }
            level.method_8652(pos, transformedBlock.method_9564(), flags);
        } else if (distance > 0.75) {
            if ((double)rand > horizontalDistance) {
                level.method_8652(pos, class_2246.field_10124.method_9564(), flags);
            } else {
                level.method_8652(pos, class_2246.field_10036.method_9564(), flags);
            }
        } else {
            level.method_8652(pos, class_2246.field_10124.method_9564(), flags);
        }
        level.method_14199((class_2394)class_2398.field_17909, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
        level.method_14199((class_2394)class_2398.field_11251, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), 1, 0.0, 0.0, 0.0, 0.0);
        this.tryTransformChunkBiome(level, pos);
    }

    private void tryTransformChunkBiome(class_3218 level, class_2338 pos) {
        class_1923 chunkPos = new class_1923(pos);
        for (int dx = -2; dx <= 2; ++dx) {
            for (int dz = -2; dz <= 2; ++dz) {
                class_1923 expandedChunkPos = new class_1923(chunkPos.field_9181 + dx, chunkPos.field_9180 + dz);
                if (this.visitedChunks.contains(expandedChunkPos)) continue;
                class_6880.class_6883 biome = level.method_30349().method_30530(class_7924.field_41236).method_40290(AVPBiomeKeys.NUKED_BIOME);
                this.setBiome(level, new class_2338(expandedChunkPos.method_8326(), 0, expandedChunkPos.method_8328()), (class_6880<class_1959>)biome);
                level.method_14178().field_17254.method_49421(List.of(level.method_8497(expandedChunkPos.field_9181, expandedChunkPos.field_9180)));
                this.visitedChunks.add(expandedChunkPos);
            }
        }
    }

    private void setBiome(class_3218 level, class_2338 pos, class_6880<class_1959> holder) {
        class_2818 chunk = level.method_8500(pos);
        chunk.method_38257((i, j, k, sampler) -> {
            int l = class_5742.method_33101((int)i);
            int m = class_5742.method_33101((int)j);
            int n = class_5742.method_33101((int)k);
            class_6880 holder2 = chunk.method_16359(i, j, k);
            return holder;
        }, level.method_14178().method_41248().method_42371());
        chunk.method_12008(true);
    }
}

