/*
 * Decompiled with CFR 0.152.
 */
package com.avp.common.util;

import com.alien.common.gameplay.entity.living.alien.Alien;
import com.alien.common.model.alien.variant.AlienVariant;
import com.alien.common.util.AlienTransitionUtil;
import com.avp.AVP;
import com.avp.common.gameplay.explosion.Explosion;
import com.avp.common.gameplay.explosion.ExplosionProgressTracker;
import com.avp.common.gameplay.explosion.nuke.NuclearExplosionEffects;
import com.avp.common.util.AVPPredicates;
import com.human.common.gameplay.entity.nuke.MushroomCloudEntity;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public class ExplosionUtil {
    public static void applyKnockback(class_243 center, double radius, class_1297 entity, double maxKnockback, double distance) {
        class_1309 livingEntity;
        class_243 direction = entity.method_19538().method_1020(center).method_1029();
        double knockbackStrength = maxKnockback * (1.0 - distance / (radius * radius));
        class_243 knockbackVelocity = direction.method_1021(Math.max(maxKnockback, knockbackStrength));
        if (entity instanceof class_1309 && AVPPredicates.IS_IMMORTAL.test(livingEntity = (class_1309)entity)) {
            return;
        }
        entity.method_18799(knockbackVelocity);
        entity.field_6037 = true;
    }

    public static double computeDamage(double radius, double minimumDamage, double maximumDamage, double distance) {
        double damageFactor = 1.0 - distance / radius;
        return Math.max(minimumDamage, maximumDamage * damageFactor);
    }

    public static List<class_1297> getEntitiesInRadius(class_3218 level, class_243 center, double radius) {
        class_238 boundingBox = new class_238(center.field_1352 - radius, center.field_1351 - radius, center.field_1350 - radius, center.field_1352 + radius, center.field_1351 + radius, center.field_1350 + radius);
        return level.method_8335(null, boundingBox);
    }

    public static double getNormalizedHorizontalDistance(Explosion explosion, int x, int z) {
        int radiusX = explosion.config().largestRadius(class_2350.class_2351.field_11048);
        int radiusZ = explosion.config().largestRadius(class_2350.class_2351.field_11051);
        return (double)(x * x) / (double)(radiusX * radiusX) + (double)(z * z) / (double)(radiusZ * radiusZ);
    }

    public static double getNormalizedVerticalDistance(Explosion explosion, int y) {
        int radiusYDown = explosion.config().radius(class_2350.field_11033);
        int radiusYUp = explosion.config().radius(class_2350.field_11036);
        return y < 0 ? (double)(y * y) / (double)(radiusYDown * radiusYDown) : (double)(y * y) / (double)(radiusYUp * radiusYUp);
    }

    public static double getNormalizedDistance(Explosion explosion, int x, int y, int z) {
        return ExplosionUtil.getNormalizedHorizontalDistance(explosion, x, z) + ExplosionUtil.getNormalizedVerticalDistance(explosion, y);
    }

    public static Explosion createNuclearExplosion(class_3218 level, class_243 center, int radius, int maxKnockback) {
        ExplosionProgressTracker progressTracker = new ExplosionProgressTracker();
        NuclearExplosionEffects nuclearExplosionEffects = new NuclearExplosionEffects();
        return Explosion.builder(level, center).withRadius(class_2350.class_2353.field_11062, radius).withRadius(class_2350.field_11036, radius / 2).withRadius(class_2350.field_11033, 32).onExplosionStart(() -> {
            progressTracker.startTimer();
            List<class_1297> entities = ExplosionUtil.getEntitiesInRadius(level, center, radius);
            for (class_1297 entity : entities) {
                double distance = entity.method_5707(center);
                double damage = ExplosionUtil.computeDamage(radius, 5.0, 1000.0, distance);
                if (entity instanceof Alien) {
                    Alien alien = (Alien)entity;
                    AlienTransitionUtil.transitionIntoVariant(alien, AlienVariant.IRRADIATED);
                }
                entity.method_5639(15.0f);
                entity.method_5643(level.method_48963().method_48807(null), (float)damage);
                ExplosionUtil.applyKnockback(center, radius, entity, maxKnockback, distance);
            }
            MushroomCloudEntity mushroomCloud = new MushroomCloudEntity((class_1937)level, center.method_10216(), center.method_10214() - 23.0, center.method_10215());
            level.method_8649((class_1297)mushroomCloud);
        }).onBlockSample(($, pos) -> {
            nuclearExplosionEffects.apply($, pos);
            progressTracker.incrementBlockDestroyCounter();
        }).onExplosionFinish(() -> {
            progressTracker.stopTimer();
            long timeTakenInMillis = progressTracker.timeTaken();
            long timeTakenInTicks = timeTakenInMillis / 50L;
            AVP.LOGGER.info("Explosion @ {} completed in {}ms ({} ticks), destroying {} blocks!", new Object[]{center, timeTakenInMillis, timeTakenInTicks, progressTracker.blocksDestroyed()});
        }).build();
    }
}

