/*
 * Decompiled with CFR 0.152.
 */
package com.avp.fabric.data.recipe.builder;

import com.avp.fabric.data.recipe.builder.RecipeBuilder;
import com.avp.fabric.data.recipe.util.RecipeProviderProxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2447;
import net.minecraft.class_6862;
import net.minecraft.class_7800;

public class ShapedRecipeBuilder {
    private final RecipeBuilder baseBuilder;
    private final List<UnaryOperator<class_2447>> transformations;
    private class_7800 recipeCategory;
    private UnaryOperator<String> customNameOperator;

    ShapedRecipeBuilder(RecipeBuilder baseBuilder) {
        this.baseBuilder = baseBuilder;
        this.transformations = new ArrayList<UnaryOperator<class_2447>>();
        this.recipeCategory = class_7800.field_40642;
    }

    public ShapedRecipeBuilder withCategory(class_7800 recipeCategory) {
        this.recipeCategory = recipeCategory;
        return this;
    }

    public ShapedRecipeBuilder withCustomName(UnaryOperator<String> customNameOperator) {
        this.customNameOperator = customNameOperator;
        return this;
    }

    public ShapedRecipeBuilder apply(UnaryOperator<ShapedRecipeBuilder> unaryOperator) {
        return (ShapedRecipeBuilder)unaryOperator.apply(this);
    }

    public ShapedRecipeBuilder define(char key, Supplier<? extends class_1935> itemLikeSupplier) {
        return this.define(key, itemLikeSupplier.get());
    }

    public ShapedRecipeBuilder define(char key, class_1935 itemLike) {
        this.transformations.add(shapedRecipeBuilder -> {
            String itemName = RecipeProviderProxy.getNameForItem((class_1935)itemLike.method_8389());
            shapedRecipeBuilder.method_10434(Character.valueOf(key), itemLike);
            shapedRecipeBuilder.method_10429("has_" + itemName, RecipeProviderProxy.has(itemLike));
            return shapedRecipeBuilder;
        });
        return this;
    }

    public ShapedRecipeBuilder define(char key, class_6862<class_1792> itemTagKey) {
        this.transformations.add(shapedRecipeBuilder -> {
            shapedRecipeBuilder.method_10433(Character.valueOf(key), itemTagKey);
            shapedRecipeBuilder.method_10429("has_" + itemTagKey.comp_327().method_12832(), RecipeProviderProxy.has(itemTagKey));
            return shapedRecipeBuilder;
        });
        return this;
    }

    public ShapedRecipeBuilder define(char key, class_1856 ingredient) {
        this.transformations.add(shapedRecipeBuilder -> {
            shapedRecipeBuilder.method_10428(Character.valueOf(key), ingredient);
            Arrays.stream(ingredient.method_8105()).forEach(itemStack -> {
                class_1792 itemLike = itemStack.method_7909();
                String itemName = RecipeProviderProxy.getNameForItem((class_1935)itemLike.method_8389());
                shapedRecipeBuilder.method_10429("has_" + itemName, RecipeProviderProxy.has((class_1935)itemLike));
            });
            return shapedRecipeBuilder;
        });
        return this;
    }

    public ShapedRecipeBuilder pattern(String pattern) {
        this.transformations.add(shapedRecipeBuilder -> {
            shapedRecipeBuilder.method_10439(pattern);
            return shapedRecipeBuilder;
        });
        return this;
    }

    public void into(int count, Supplier<? extends class_1935> destinationSupplier) {
        this.into(count, destinationSupplier.get());
    }

    public void into(int count, class_1935 destination) {
        class_2447 builder = class_2447.method_10436((class_7800)this.recipeCategory, (class_1935)destination, (int)count);
        for (UnaryOperator<class_2447> transformation : this.transformations) {
            builder = (class_2447)transformation.apply(builder);
        }
        if (this.customNameOperator == null) {
            builder.method_10431(this.baseBuilder.getRecipeOutput());
        } else {
            String destinationName = RecipeProviderProxy.getNameForItem(destination);
            builder.method_36443(this.baseBuilder.getRecipeOutput(), (String)this.customNameOperator.apply(destinationName));
        }
    }
}

