/*
 * Decompiled with CFR 0.152.
 */
package com.avp.fabric.data.recipe.impl;

import com.alien.common.registry.init.AlienItems;
import com.alien.common.registry.init.item.AlienArmorItems;
import com.avp.common.registry.init.item.AVPArmorItems;
import com.avp.common.registry.init.item.AVPItems;
import com.avp.common.registry.tag.AVPItemTags;
import com.avp.fabric.data.recipe.RecipeTemplates;
import com.avp.fabric.data.recipe.builder.RecipeBuilder;
import com.avp.fabric.data.recipe.builder.ShapedRecipeBuilder;
import com.compat.CommonItemTags;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_3489;
import net.minecraft.class_6862;
import net.minecraft.class_7800;

public class ArmorRecipeProvider {
    public static void provide(RecipeBuilder builder) {
        ArmorRecipeProvider.createMk50ArmorSetRecipes(builder);
        ArmorRecipeProvider.createPressureArmorSetRecipes(builder);
        ArmorRecipeProvider.createTacticalArmorSetRecipes(builder);
        ArmorRecipeProvider.createPlatedChitinArmorSetRecipes(builder);
        ArmorRecipeProvider.createPlatedAberrantChitinArmorSetRecipes(builder);
        ArmorRecipeProvider.createPlatedNetherChitinArmorSetRecipes(builder);
        ArmorRecipeProvider.createStandardArmorSetRecipes(builder, (class_1935)AlienItems.ABERRANT_CHITIN.get(), AlienArmorItems.ABERRANT_CHITIN_HELMET.get(), AlienArmorItems.ABERRANT_CHITIN_CHESTPLATE.get(), AlienArmorItems.ABERRANT_CHITIN_LEGGINGS.get(), AlienArmorItems.ABERRANT_CHITIN_BOOTS.get());
        ArmorRecipeProvider.createStandardArmorSetRecipes(builder, (class_1935)AlienItems.CHITIN.get(), AlienArmorItems.CHITIN_HELMET.get(), AlienArmorItems.CHITIN_CHESTPLATE.get(), AlienArmorItems.CHITIN_LEGGINGS.get(), AlienArmorItems.CHITIN_BOOTS.get());
        ArmorRecipeProvider.createStandardArmorSetRecipes(builder, (class_1935)AlienItems.NETHER_CHITIN.get(), AlienArmorItems.NETHER_CHITIN_HELMET.get(), AlienArmorItems.NETHER_CHITIN_CHESTPLATE.get(), AlienArmorItems.NETHER_CHITIN_LEGGINGS.get(), AlienArmorItems.NETHER_CHITIN_BOOTS.get());
        ArmorRecipeProvider.createStandardArmorSetRecipes(builder, CommonItemTags.INGOTS_STEEL, AVPArmorItems.STEEL_HELMET.get(), AVPArmorItems.STEEL_CHESTPLATE.get(), AVPArmorItems.STEEL_LEGGINGS.get(), AVPArmorItems.STEEL_BOOTS.get());
        ArmorRecipeProvider.createStandardArmorSetRecipes(builder, CommonItemTags.INGOTS_TITANIUM, AVPArmorItems.TITANIUM_HELMET.get(), AVPArmorItems.TITANIUM_CHESTPLATE.get(), AVPArmorItems.TITANIUM_LEGGINGS.get(), AVPArmorItems.TITANIUM_BOOTS.get());
    }

    private static void createPlatedAberrantChitinArmorSetRecipes(RecipeBuilder builder) {
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.ABERRANT_CHITIN_HELMET).requires(1, AlienItems.PLATED_ABERRANT_CHITIN).into(1, AlienArmorItems.PLATED_ABERRANT_CHITIN_HELMET);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.ABERRANT_CHITIN_CHESTPLATE).requires(1, AlienItems.PLATED_ABERRANT_CHITIN).into(1, AlienArmorItems.PLATED_ABERRANT_CHITIN_CHESTPLATE);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.ABERRANT_CHITIN_LEGGINGS).requires(1, AlienItems.PLATED_ABERRANT_CHITIN).into(1, AlienArmorItems.PLATED_ABERRANT_CHITIN_LEGGINGS);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.ABERRANT_CHITIN_BOOTS).requires(1, AlienItems.PLATED_ABERRANT_CHITIN).into(1, AlienArmorItems.PLATED_ABERRANT_CHITIN_BOOTS);
    }

    private static void createPlatedIrradiatedChitinArmorSetRecipes(RecipeBuilder builder) {
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.IRRADIATED_CHITIN_HELMET).requires(1, AlienItems.PLATED_IRRADIATED_CHITIN).into(1, AlienArmorItems.PLATED_IRRADIATED_CHITIN_HELMET);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.IRRADIATED_CHITIN_CHESTPLATE).requires(1, AlienItems.PLATED_IRRADIATED_CHITIN).into(1, AlienArmorItems.PLATED_IRRADIATED_CHITIN_CHESTPLATE);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.IRRADIATED_CHITIN_LEGGINGS).requires(1, AlienItems.PLATED_IRRADIATED_CHITIN).into(1, AlienArmorItems.PLATED_IRRADIATED_CHITIN_LEGGINGS);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.IRRADIATED_CHITIN_BOOTS).requires(1, AlienItems.PLATED_IRRADIATED_CHITIN).into(1, AlienArmorItems.PLATED_IRRADIATED_CHITIN_BOOTS);
    }

    private static void createPlatedNetherChitinArmorSetRecipes(RecipeBuilder builder) {
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.NETHER_CHITIN_HELMET).requires(1, AlienItems.PLATED_NETHER_CHITIN).into(1, AlienArmorItems.PLATED_NETHER_CHITIN_HELMET);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.NETHER_CHITIN_CHESTPLATE).requires(1, AlienItems.PLATED_NETHER_CHITIN).into(1, AlienArmorItems.PLATED_NETHER_CHITIN_CHESTPLATE);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.NETHER_CHITIN_LEGGINGS).requires(1, AlienItems.PLATED_NETHER_CHITIN).into(1, AlienArmorItems.PLATED_NETHER_CHITIN_LEGGINGS);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.NETHER_CHITIN_BOOTS).requires(1, AlienItems.PLATED_NETHER_CHITIN).into(1, AlienArmorItems.PLATED_NETHER_CHITIN_BOOTS);
    }

    private static void createPlatedChitinArmorSetRecipes(RecipeBuilder builder) {
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.CHITIN_HELMET).requires(1, AlienItems.PLATED_CHITIN).into(1, AlienArmorItems.PLATED_CHITIN_HELMET);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.CHITIN_CHESTPLATE).requires(1, AlienItems.PLATED_CHITIN).into(1, AlienArmorItems.PLATED_CHITIN_CHESTPLATE);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.CHITIN_LEGGINGS).requires(1, AlienItems.PLATED_CHITIN).into(1, AlienArmorItems.PLATED_CHITIN_LEGGINGS);
        builder.shapeless().withCategory(class_7800.field_40639).requires(1, AlienArmorItems.CHITIN_BOOTS).requires(1, AlienItems.PLATED_CHITIN).into(1, AlienArmorItems.PLATED_CHITIN_BOOTS);
    }

    private static void createMk50ArmorSetRecipes(RecipeBuilder builder) {
        Supplier<ShapedRecipeBuilder> mk50ArmorBuilder = () -> builder.shaped().withCategory(class_7800.field_40639).define('A', CommonItemTags.INGOTS_ALUMINUM).define('C', CommonItemTags.INGOTS_LEAD);
        mk50ArmorBuilder.get().define('B', AVPItemTags.INDUSTRIAL_GLASS_PANE).define('E', CommonItemTags.DUSTS_COAL).pattern("CAC").pattern("B B").pattern("AEA").into(1, AVPArmorItems.MK50_HELMET);
        mk50ArmorBuilder.get().define('D', CommonItemTags.LEATHERS).pattern("A A").pattern("CAC").pattern("DAD").into(1, AVPArmorItems.MK50_CHESTPLATE);
        mk50ArmorBuilder.get().define('D', CommonItemTags.LEATHERS).pattern("CDC").pattern("D D").pattern("A A").into(1, AVPArmorItems.MK50_LEGGINGS);
        mk50ArmorBuilder.get().pattern("C C").pattern("A A").into(1, AVPArmorItems.MK50_BOOTS);
    }

    private static void createPressureArmorSetRecipes(RecipeBuilder builder) {
        Supplier<ShapedRecipeBuilder> pressureArmorBuilder = () -> builder.shaped().withCategory(class_7800.field_40639).define('A', CommonItemTags.INGOTS_ALUMINUM);
        pressureArmorBuilder.get().define('B', AVPItemTags.INDUSTRIAL_GLASS_PANE).define('E', CommonItemTags.DUSTS_COAL).pattern("AAA").pattern("B B").pattern("EEE").into(1, AVPArmorItems.PRESSURE_HELMET);
        pressureArmorBuilder.get().define('D', (class_6862<class_1792>)class_3489.field_15544).pattern("A A").pattern("ADA").pattern("DAD").into(1, AVPArmorItems.PRESSURE_CHESTPLATE);
        pressureArmorBuilder.get().define('D', (class_6862<class_1792>)class_3489.field_15544).pattern("ADA").pattern("D D").pattern("A A").into(1, AVPArmorItems.PRESSURE_LEGGINGS);
        pressureArmorBuilder.get().define('D', (class_6862<class_1792>)class_3489.field_15544).pattern("D D").pattern("A A").into(1, AVPArmorItems.PRESSURE_BOOTS);
    }

    private static void createTacticalArmorSetRecipes(RecipeBuilder builder) {
        Supplier<ShapedRecipeBuilder> tacticalArmorBuilder = () -> builder.shaped().withCategory(class_7800.field_40639).define('A', CommonItemTags.INGOTS_STEEL).define('B', (class_6862<class_1792>)class_3489.field_15544);
        tacticalArmorBuilder.get().define('C', AVPItems.POLYMER).pattern("ABA").pattern("C C").into(1, AVPArmorItems.TACTICAL_HELMET);
        tacticalArmorBuilder.get().define('C', AVPItems.POLYMER).pattern("C C").pattern("ABA").pattern("CAC").into(1, AVPArmorItems.TACTICAL_CHESTPLATE);
        tacticalArmorBuilder.get().define('C', AVPItems.POLYMER).pattern("CBC").pattern("A A").pattern("C C").into(1, AVPArmorItems.TACTICAL_LEGGINGS);
        tacticalArmorBuilder.get().pattern("B B").pattern("A A").into(1, AVPArmorItems.TACTICAL_BOOTS);
    }

    private static void createStandardArmorSetRecipes(RecipeBuilder builder, class_1935 base, class_1792 helmet, class_1792 chestplate, class_1792 leggings, class_1792 boots) {
        builder.shaped().apply(RecipeTemplates.HELMET.apply(base)).into(1, (class_1935)helmet);
        builder.shaped().apply(RecipeTemplates.CHESTPLATE.apply(base)).into(1, (class_1935)chestplate);
        builder.shaped().apply(RecipeTemplates.LEGGINGS.apply(base)).into(1, (class_1935)leggings);
        builder.shaped().apply(RecipeTemplates.BOOTS.apply(base)).into(1, (class_1935)boots);
    }

    private static void createStandardArmorSetRecipes(RecipeBuilder builder, class_6862<class_1792> base, class_1792 helmet, class_1792 chestplate, class_1792 leggings, class_1792 boots) {
        builder.shaped().apply(RecipeTemplates.HELMET_TAG_FRIENDLY.apply(base)).into(1, (class_1935)helmet);
        builder.shaped().apply(RecipeTemplates.CHESTPLATE_TAG_FRIENDLY.apply(base)).into(1, (class_1935)chestplate);
        builder.shaped().apply(RecipeTemplates.LEGGINGS_TAG_FRIENDLY.apply(base)).into(1, (class_1935)leggings);
        builder.shaped().apply(RecipeTemplates.BOOTS_TAG_FRIENDLY.apply(base)).into(1, (class_1935)boots);
    }
}

