/*
 * Decompiled with CFR 0.152.
 */
package com.avp.mixin;

import com.alien.common.gameplay.entity.living.alien.parasite.Parasite;
import com.alien.common.model.alien.Host;
import com.alien.common.model.lifecycle.infection.Infection;
import com.alien.common.registry.InfectionRegistry;
import com.alien.common.util.AlienEmbryoUtil;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_1309.class})
public abstract class MixinLivingEntity_Host
extends class_1297
implements Host {
    @Unique
    private static final String NBT_PARASITE_GENES = "parasiteGenes";
    @Unique
    private static final String NBT_EMBRYO_GROWTH_TIME_IN_TICKS = "embryoGrowthTimeInTicks";
    @Unique
    private static final String NBT_EMBRYO_TYPE = "embryoType";
    @Unique
    private int embryoGrowthTimeInTicks;
    @Unique
    private Option<class_1299<?>> embryoTypeOption = Option.none();
    @Unique
    private GeneContainer parasiteGeneContainer;

    public MixinLivingEntity_Host(class_1299<?> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    public void tick(CallbackInfo callbackInfo) {
        class_1309 self = (class_1309)class_1309.class.cast(this);
        AlienEmbryoUtil.runAlienEmbryoRoutines(self);
    }

    @Inject(at={@At(value="HEAD")}, method={"readAdditionalSaveData"})
    public void readAdditionalSaveData(class_2487 compoundTag, CallbackInfo callbackInfo) {
        this.embryoGrowthTimeInTicks = compoundTag.method_10550(NBT_EMBRYO_GROWTH_TIME_IN_TICKS);
        if (compoundTag.method_10545(NBT_EMBRYO_TYPE)) {
            String resourceLocationString = compoundTag.method_10558(NBT_EMBRYO_TYPE);
            class_2960 resourceLocation = class_2960.method_60654((String)resourceLocationString);
            Optional entityTypeHolderOptional = class_7923.field_41177.method_55841(resourceLocation);
            entityTypeHolderOptional.ifPresent($ -> {
                this.embryoTypeOption = Option.some((Object)((class_1299)class_7923.field_41177.method_10223(resourceLocation)));
            });
        }
        if (compoundTag.method_10545(NBT_PARASITE_GENES)) {
            class_2487 tag = compoundTag.method_10562(NBT_PARASITE_GENES);
            this.getOrCreateParasiteGeneContainer().load(tag);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addAdditionalSaveData"})
    public void addAdditionalSaveData(class_2487 compoundTag, CallbackInfo callbackInfo) {
        compoundTag.method_10569(NBT_EMBRYO_GROWTH_TIME_IN_TICKS, this.embryoGrowthTimeInTicks);
        this.embryoTypeOption.ifSome(embryoType -> {
            class_2960 resourceLocation = class_7923.field_41177.method_10221(embryoType);
            compoundTag.method_10582(NBT_EMBRYO_TYPE, resourceLocation.toString());
        });
        class_2487 tag = new class_2487();
        this.getOrCreateParasiteGeneContainer().save(tag);
        compoundTag.method_10566(NBT_PARASITE_GENES, (class_2520)tag);
    }

    @Override
    public void implantEmbryo(Parasite parasite) {
        Option<Infection> infectionOption = InfectionRegistry.get(this.method_5864(), parasite.method_5864());
        infectionOption.ifSome(infection -> {
            this.setEmbryoType(infection.embryoType());
            parasite.getGeneManager().getGeneContainer().transfer(this.getOrCreateParasiteGeneContainer(), false);
            class_1309 self = (class_1309)class_1309.class.cast(this);
            if (self instanceof class_1308) {
                class_1308 mob = (class_1308)self;
                mob.method_5971();
            }
        });
    }

    @Override
    public GeneContainer getOrCreateParasiteGeneContainer() {
        if (this.parasiteGeneContainer == null) {
            this.parasiteGeneContainer = new GeneContainer();
        }
        return this.parasiteGeneContainer;
    }

    @Override
    public Option<class_1299<?>> getEmbryoType() {
        return this.embryoTypeOption;
    }

    @Override
    public void setEmbryoType(@Nullable class_1299<?> embryoType) {
        this.embryoTypeOption = Option.ofNullable(embryoType);
    }

    @Override
    public int getEmbryoGrowthTimeInTicks() {
        return this.embryoGrowthTimeInTicks;
    }

    @Override
    public void setEmbryoGrowthTimeInTicks(int embryoGrowthTimeInTicks) {
        this.embryoGrowthTimeInTicks = embryoGrowthTimeInTicks;
    }
}

