/*
 * Decompiled with CFR 0.152.
 */
package com.avp.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BlockBreakProgressManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(BlockBreakProgressManager.class);
    private static final Map<class_2338, Map.Entry<Long, Float>> BLOCK_BREAK_PROGRESS_MAP = new HashMap<class_2338, Map.Entry<Long, Float>>();

    public static void tick(class_1937 level) {
        long gameTime = level.method_8510();
        if (gameTime % 400L != 0L) {
            return;
        }
        LOGGER.debug("Cleaning block break progress map ({} entries)", (Object)BLOCK_BREAK_PROGRESS_MAP.size());
        BLOCK_BREAK_PROGRESS_MAP.entrySet().removeIf(entry -> {
            Long lastUpdateTimeMillis = (Long)((Map.Entry)entry.getValue()).getKey();
            return System.currentTimeMillis() > lastUpdateTimeMillis;
        });
        LOGGER.debug("Finished cleaning block break progress map ({} entries)", (Object)BLOCK_BREAK_PROGRESS_MAP.size());
    }

    public static void resetProgress(class_1937 level, class_2338 pos) {
        BLOCK_BREAK_PROGRESS_MAP.remove(pos);
        level.method_8517(BlockBreakProgressManager.computeBlockPosHash(pos), pos, -1);
    }

    public static void setProgress(class_1937 level, class_2338 pos, float progress) {
        Map.Entry<Long, Float> newEntry = Map.entry(System.currentTimeMillis() + TimeUnit.MINUTES.toMillis(5L), Float.valueOf(progress));
        BLOCK_BREAK_PROGRESS_MAP.put(pos, newEntry);
        int clampedProgress = BlockBreakProgressManager.getClampedProgress(progress);
        level.method_8517(BlockBreakProgressManager.computeBlockPosHash(pos), pos, clampedProgress);
    }

    public static Result damage(class_1937 level, class_2338 blockPos, float damage) {
        class_2338 immutableBlockPos = blockPos.method_10062();
        Map.Entry<Long, Float> entry = BLOCK_BREAK_PROGRESS_MAP.get(immutableBlockPos);
        class_2680 blockState = level.method_8320(immutableBlockPos);
        class_2248 block = blockState.method_26204();
        float currentDestroyProgress = entry == null ? 0.0f : entry.getValue().floatValue();
        float defaultDestroyTimeInSeconds = block.method_36555();
        if (defaultDestroyTimeInSeconds < 0.0f || blockState.method_27852(class_2246.field_10036)) {
            return Result.NOT_DAMAGED;
        }
        float destroyTimeInTicks = block.method_36555() * 20.0f;
        float weight = Math.max(destroyTimeInTicks, 1.0f);
        float newDestroyProgress = currentDestroyProgress + damage / weight;
        if (newDestroyProgress >= 9.0f) {
            BlockBreakProgressManager.resetProgress(level, immutableBlockPos);
            level.method_22352(immutableBlockPos, false);
            return Result.DESTROYED;
        }
        BlockBreakProgressManager.setProgress(level, immutableBlockPos, newDestroyProgress);
        return Result.DAMAGED;
    }

    private static int getClampedProgress(float progress) {
        return (int)class_3532.method_15363((float)progress, (float)-1.0f, (float)9.0f);
    }

    private static int computeBlockPosHash(class_2338 pos) {
        return Objects.hash(pos);
    }

    private BlockBreakProgressManager() {
        throw new UnsupportedOperationException();
    }

    public static enum Result {
        DAMAGED,
        DESTROYED,
        NOT_DAMAGED;

    }
}

