/*
 * Decompiled with CFR 0.152.
 */
package com.avp.server;

import com.alien.common.gameplay.level.saveddata.HiveLevelData;
import com.avp.server.BlockBreakProgressManager;
import com.avp.server.ServerScheduler;
import com.human.common.gameplay.power.PowerSystem;
import com.lib.common.data.Cooldown;
import java.time.Duration;
import net.minecraft.class_1937;
import net.minecraft.class_3218;

public class ServerLevelManager {
    private final Cooldown queenSpawnCooldown = Cooldown.withCooldownTime("queenSpawnCooldownInTicks", Duration.ofMinutes(5L));

    public ServerLevelManager() {
        this.queenSpawnCooldown.reset();
    }

    public void tick(class_3218 serverLevel) {
        this.tickScheduledRunnables();
        this.queenSpawnCooldown.tick();
        HiveLevelData.getOrCreate((class_1937)serverLevel).ifSome(HiveLevelData::tick);
        BlockBreakProgressManager.tick((class_1937)serverLevel);
        PowerSystem.get(serverLevel).tick();
    }

    private void tickScheduledRunnables() {
        ServerScheduler.getScheduledTasks().removeIf(entry -> {
            Long runTime = (Long)entry.getKey();
            if (System.currentTimeMillis() >= runTime) {
                ((Runnable)entry.getValue()).run();
                return true;
            }
            return false;
        });
    }

    public Cooldown getQueenSpawnCooldown() {
        return this.queenSpawnCooldown;
    }
}

