/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.block.entity.power.impl;

import com.alien.common.data.AlienVariantTypes;
import com.avp.AVP;
import com.avp.common.registry.init.AVPBlockEntityTypes;
import com.avp.common.registry.tag.AVPBlockTags;
import com.human.common.gameplay.block.entity.power.PowerConsumerBlockEntity;
import com.human.common.gameplay.block.entity.power.impl.ResonatorAnimationDispatcher;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public class ResonatorBlockEntity
extends PowerConsumerBlockEntity {
    private int tickCounter = 0;
    private final ResonatorAnimationDispatcher animationDispatcher = new ResonatorAnimationDispatcher();
    private final Map<class_1792, Integer> resinBallCounts = new HashMap<class_1792, Integer>();

    public ResonatorBlockEntity(class_2338 pos, class_2680 blockState) {
        super(AVPBlockEntityTypes.RESONATOR.get(), pos, blockState);
    }

    @Override
    public long getRequestedPower() {
        return 1000L;
    }

    @Override
    public void unpoweredTick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        this.animationDispatcher.unpowered(this);
    }

    @Override
    public void poweredTick(class_1937 level, class_2338 blockPos, class_2680 blockState) {
        this.animationDispatcher.powered(this);
        ++this.tickCounter;
        int tickValue = AVP.config.blockConfigs.RESONATOR_REPLACE_TICKS;
        if (this.tickCounter % tickValue != 0) {
            return;
        }
        int radius = AVP.config.blockConfigs.RESONATOR_REPLACE_RADIUS;
        class_2338.method_20437((class_2338)blockPos.method_10069(-radius, -radius, -radius), (class_2338)blockPos.method_10069(radius, radius, radius)).forEach(currentPos -> {
            class_2680 currentState = level.method_8320(currentPos);
            AlienVariantTypes.getFor(currentState).ifSome(alienVariantType -> {
                if (currentState.method_26164(AVPBlockTags.RESIN_VEINS)) {
                    level.method_8501(currentPos, class_2246.field_10124.method_9564());
                    class_1792 resinBallItem = alienVariantType.resinBall().get();
                    this.addResinBallItem(resinBallItem);
                    this.method_5431();
                    return;
                }
                if (currentState.method_26164(AVPBlockTags.RESIN)) {
                    class_2248 replacementBlock = currentPos.method_10264() <= 0 ? class_2246.field_28888 : class_2246.field_10340;
                    level.method_8501(currentPos, replacementBlock.method_9564());
                    class_1792 resinBallItem = alienVariantType.resinBall().get();
                    this.addResinBallItem(resinBallItem);
                    this.method_5431();
                }
            });
        });
    }

    public void addResinBallItem(class_1792 resinBallItem) {
        this.resinBallCounts.merge(resinBallItem, 1, Integer::sum);
        this.method_5431();
    }

    public Map<class_1792, Integer> getResinBallCounts() {
        return Collections.unmodifiableMap(this.resinBallCounts);
    }

    public void onRightClick(class_1657 player) {
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        if (!this.resinBallCounts.isEmpty()) {
            for (Map.Entry<class_1792, Integer> entry : this.resinBallCounts.entrySet()) {
                class_1792 resinBallItem = entry.getKey();
                Integer count = entry.getValue();
                if (count <= 0) continue;
                class_1799 resinBallStack = new class_1799((class_1935)resinBallItem, count.intValue());
                class_1542 resinBallEntity = new class_1542(this.field_11863, player.method_23317(), player.method_23318(), player.method_23321(), resinBallStack);
                this.field_11863.method_8649((class_1297)resinBallEntity);
            }
            this.resinBallCounts.clear();
            this.method_5431();
        }
    }
}

