/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.entity.living.human.marine;

import com.avp.AVP;
import com.avp.common.model.inventory.AVPInventory;
import com.avp.common.model.inventory.AVPInventoryBearer;
import com.avp.common.registry.init.item.AVPArmorItems;
import com.avp.common.registry.init.item.AVPItems;
import com.human.common.gameplay.entity.living.human.AbstractHuman;
import com.human.common.gameplay.entity.living.human.marine.MarineAnimationDispatcher;
import com.human.common.gameplay.entity.living.human.marine.MarineInventory;
import com.human.common.gameplay.entity.living.human.marine.ai.MarineGOAP;
import com.human.common.registry.init.item.HumanGunItems;
import com.lib.common.gameplay.goap.GOAPUser;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1266;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Marine
extends AbstractHuman
implements AVPInventoryBearer,
GOAPUser<MarineGOAP> {
    private static final List<List<Supplier<class_1792>>> DEFAULT_ARMOR_SETS = List.of(List.of(AVPArmorItems.TACTICAL_HELMET, AVPArmorItems.TACTICAL_CHESTPLATE, AVPArmorItems.TACTICAL_LEGGINGS, AVPArmorItems.TACTICAL_BOOTS), List.of(AVPArmorItems.TACTICAL_CAMO_HELMET, AVPArmorItems.TACTICAL_CAMO_CHESTPLATE, AVPArmorItems.TACTICAL_CAMO_LEGGINGS, AVPArmorItems.TACTICAL_CAMO_BOOTS));
    private static final List<Supplier<class_1792>> USABLE_WEAPON_ITEM_SUPPLIERS = List.of(HumanGunItems.M88MOD4_COMBAT_PISTOL, HumanGunItems.M37_12_SHOTGUN, HumanGunItems.F903WE_RIFLE, HumanGunItems.M41A_PULSE_RIFLE, HumanGunItems.M4RA_BATTLE_RIFLE, () -> class_1802.field_8475, () -> class_1802.field_8371);
    private static final List<class_1304> ARMOR_EQUIPMENT_SLOTS = List.of(class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166);
    private final MarineAnimationDispatcher animationDispatcher = new MarineAnimationDispatcher(this);
    private final MarineInventory marineInventory = new MarineInventory(this);

    public static class_5132.class_5133 createMarineAttributes() {
        return Marine.applyFrom(AVP.config.statsConfigs.MARINE_STATS, class_1308.method_26828().method_26867(class_5134.field_23721));
    }

    public Marine(class_1299<? extends class_1314> entityType, class_1937 level) {
        super(entityType, level);
    }

    @Override
    @Nullable
    public MarineGOAP createGOAP() {
        return new MarineGOAP(this);
    }

    @Override
    public void runAttackAnimations() {
        this.animationDispatcher.rightShoot();
    }

    protected void method_16078() {
        super.method_16078();
        this.marineInventory.dropItems();
    }

    @Nullable
    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 spawnType, @Nullable class_1315 spawnGroupData) {
        this.addInitialWeapon();
        this.marineInventory.addPersonalItem(new class_1799((class_1935)AVPItems.GRENADE.get()));
        this.addInitialArmor();
        return super.method_5943(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    public AVPInventory getInventory() {
        return this.marineInventory;
    }

    public void method_5749(@NotNull class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.marineInventory.load(compoundTag);
    }

    public void method_5652(@NotNull class_2487 compoundTag) {
        super.method_5652(compoundTag);
        this.marineInventory.save(compoundTag);
    }

    private void addInitialArmor() {
        int randomArmorSetIndex = this.method_59922().method_43048(DEFAULT_ARMOR_SETS.size());
        class_1799[] selectedArmor = (class_1799[])DEFAULT_ARMOR_SETS.get(randomArmorSetIndex).stream().map(itemSupplier -> new class_1799((class_1935)itemSupplier.get())).toArray(class_1799[]::new);
        for (int i = 0; i < ARMOR_EQUIPMENT_SLOTS.size(); ++i) {
            class_1799 itemStack = selectedArmor[i];
            class_1738 armorItem = (class_1738)itemStack.method_7909();
            this.method_5673(armorItem.method_7685(), itemStack);
        }
    }

    private void addInitialWeapon() {
        this.marineInventory.addPersonalItem(new class_1799((class_1935)USABLE_WEAPON_ITEM_SUPPLIERS.get(this.field_5974.method_43048(USABLE_WEAPON_ITEM_SUPPLIERS.size())).get()));
    }
}

