/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.canister;

import com.human.common.gameplay.item.canister.CanisterItem;
import com.human.common.registry.init.HumanDataComponents;
import java.util.List;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_174;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3468;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class SolidCanisterItem
extends class_1747 {
    private final class_3414 placeSound;

    public SolidCanisterItem(class_2248 block, class_3414 placeSound, class_1792.class_1793 properties) {
        super(block, properties);
        this.placeSound = placeSound;
    }

    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 tooltipFlag) {
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
        int currentContentAmount = (Integer)stack.method_57825(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
        if (currentContentAmount == 0) {
            return;
        }
        tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.avp.capacity").method_27693(currentContentAmount + "/8"));
    }

    @NotNull
    public class_1269 method_7884(class_1838 context) {
        class_1657 player = context.method_8036();
        if (player == null) {
            return class_1269.field_5814;
        }
        class_1838 modifiedContext = new class_1838(context.method_8045(), player, context.method_20287(), context.method_8041().method_7972(), SolidCanisterItem.method_7872((class_1937)context.method_8045(), (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348));
        class_1269 result = super.method_7884(modifiedContext);
        if (result.method_23665() && player.method_5715()) {
            int contentAmount = (Integer)context.method_8041().method_57825(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0);
            if (contentAmount > 1 && !player.method_7337()) {
                CanisterItem.updateCapacity((class_1309)player, context.method_8041(), -1);
                return result;
            }
            player.method_6122(context.method_20287(), CanisterItem.getEmptySuccessItem(context.method_8041(), player));
            return class_1269.field_5812;
        }
        class_3965 hitResult = SolidCanisterItem.method_7872((class_1937)context.method_8045(), (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1345);
        if (CanisterItem.isInvalidHitResult(hitResult)) {
            return class_1269.field_5811;
        }
        class_2338 hitPos = hitResult.method_17777();
        class_2350 hitDir = hitResult.method_17780();
        class_2338 relativePos = hitPos.method_10093(hitDir);
        if (!CanisterItem.canPlayerInteract(context.method_8045(), player, hitPos, relativePos, hitDir, context.method_8041())) {
            return class_1269.field_5814;
        }
        class_2680 hitState = context.method_8045().method_8320(hitPos);
        if (CanisterItem.isFluidPickupAction(player, hitState)) {
            return this.handlePowderSnowPickup(player, context.method_8045(), context.method_8041(), hitPos, hitState);
        }
        return class_1269.field_5814;
    }

    private class_1269 handlePowderSnowPickup(class_1657 player, class_1937 level, class_1799 canisterStack, class_2338 hitPos, class_2680 hitState) {
        class_2263 bucketPickup = (class_2263)hitState.method_26204();
        if ((Integer)canisterStack.method_57825(HumanDataComponents.CANISTER_CAPACITY.get(), (Object)0) >= 8) {
            return class_1269.field_5814;
        }
        bucketPickup.method_9700(player, (class_1936)level, hitPos, hitState);
        player.method_7259(class_3468.field_15372.method_14956((Object)this));
        bucketPickup.method_32351().ifPresent(sound -> player.method_5783(sound, 1.0f, 1.0f));
        level.method_33596((class_1297)player, (class_6880)class_5712.field_28167, hitPos);
        CanisterItem.updateCapacity((class_1309)player, canisterStack, 1);
        if (!level.field_9236) {
            class_174.field_1208.method_8932((class_3222)player, canisterStack);
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    protected boolean method_7708(class_1750 context, @NotNull class_2680 state) {
        return context.method_8036() != null && context.method_8036().method_5715() && super.method_7708(context, state);
    }

    @NotNull
    public String method_7876() {
        return this.method_7869();
    }

    @NotNull
    protected class_3414 method_19260(@NotNull class_2680 state) {
        return this.placeSound;
    }
}

