/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun;

import com.avp.common.registry.init.item.AVPBlockItems;
import com.avp.common.util.AVPPredicates;
import com.avp.server.ServerScheduler;
import com.human.common.gameplay.item.GunItem;
import com.human.common.gameplay.item.gun.FireModeConfig;
import com.human.common.gameplay.item.gun.GunConfig;
import com.human.common.gameplay.item.gun.GunData;
import com.human.common.registry.init.HumanDataComponents;
import com.lib.common.gameplay.util.EnchantmentUtil;
import java.lang.runtime.SwitchBootstraps;
import java.time.Duration;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_9288;
import net.minecraft.class_9334;

public class GunReloading {
    public static void reload(class_1657 player) {
        int ammunitionToRestore;
        ItemConsumptionResult.Full result;
        if (player == null) {
            return;
        }
        class_1937 level = player.method_37908();
        class_1268 usedItemHand = player.method_6058();
        class_1799 itemStack = player.method_5998(usedItemHand);
        class_1792 item = itemStack.method_7909();
        if (!(item instanceof GunItem)) {
            return;
        }
        GunItem gunItem = (GunItem)item;
        GunConfig gunConfig = gunItem.getGunConfig();
        int maximumAmmunition = gunConfig.maximumAmmunition();
        if (gunConfig == GunData.OLD_PAINLESS) {
            return;
        }
        int currentAmmunition = (Integer)itemStack.method_57825(HumanDataComponents.AMMUNITION.get(), (Object)0);
        if (currentAmmunition >= maximumAmmunition) {
            return;
        }
        Supplier<class_1935> ammunitionItemSupplier = gunConfig.ammunitionItemSupplier();
        if (ammunitionItemSupplier == null) {
            return;
        }
        class_1935 ammunitionItem = ammunitionItemSupplier.get();
        int reloadAmount = gunConfig.reloadAmount();
        int neededAmmunition = (int)Math.ceil((float)(maximumAmmunition - currentAmmunition) / (float)reloadAmount);
        boolean isPlayerImmortal = AVPPredicates.IS_IMMORTAL.test((class_1309)player);
        ItemConsumptionResult.Full full = result = isPlayerImmortal ? ItemConsumptionResult.Full.INSTANCE : GunReloading.consumeItemAmountFromInventory(player, ammunitionItem, neededAmmunition, true);
        Objects.requireNonNull(full);
        ItemConsumptionResult.Full full2 = full;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemConsumptionResult.Full.class, ItemConsumptionResult.None.class, ItemConsumptionResult.Partial.class}, (Object)full2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                ItemConsumptionResult.Full full3 = full2;
                int n2 = neededAmmunition;
                break;
            }
            case 1: {
                ItemConsumptionResult.None none = (ItemConsumptionResult.None)((Object)full2);
                int n2 = 0;
                break;
            }
            case 2: {
                ItemConsumptionResult.Partial partial = (ItemConsumptionResult.Partial)((Object)full2);
                int n2 = ammunitionToRestore = neededAmmunition - partial.remainingAmount;
            }
        }
        if (ammunitionToRestore == 0) {
            return;
        }
        GunItem.reload.sendForItem((class_1297)player, itemStack);
        FireModeConfig fireModeConfig = gunConfig.getDefaultFireMode();
        Supplier<class_3414> reloadStartSoundEvent = fireModeConfig.reloadStartSoundEvent();
        if (reloadStartSoundEvent != null) {
            level.method_45447(null, player.method_24515(), reloadStartSoundEvent.get(), class_3419.field_15248);
        }
        itemStack.method_57379(HumanDataComponents.AMMUNITION.get(), (Object)Math.min(currentAmmunition + ammunitionToRestore * reloadAmount, maximumAmmunition));
        if (!isPlayerImmortal) {
            double reloadTimeModifier = (double)EnchantmentUtil.getLevel(level, itemStack, (class_5321<class_1887>)class_1893.field_9098) * 0.2;
            int reloadTimeInTicks = (int)((double)gunConfig.reloadTimeInTicks() * (1.0 - reloadTimeModifier));
            player.method_7357().method_7906(itemStack.method_7909(), reloadTimeInTicks);
            ServerScheduler.schedule(() -> {
                class_1268 interactionHand;
                class_1799 itemInHand;
                Supplier<class_3414> reloadFinishSoundEvent = fireModeConfig.reloadFinishSoundEvent();
                if (reloadFinishSoundEvent != null && Objects.equals(itemStack, itemInHand = player.method_5998(interactionHand = player.method_6058()))) {
                    level.method_45447(null, player.method_24515(), reloadFinishSoundEvent.get(), class_3419.field_15248);
                }
            }, Duration.ofMillis((long)reloadTimeInTicks * 50L));
        }
    }

    public static ItemConsumptionResult consumeItemAmountFromInventory(class_1657 player, class_1935 ammunitionItem, int amountToConsume, boolean consume) {
        ItemConsumptionResult result = GunReloading.consumeItemAmountFromInventoryNoSync(player, ammunitionItem, amountToConsume, consume);
        if (result == ItemConsumptionResult.None.INSTANCE) {
            return result;
        }
        player.method_31548().method_5431();
        player.field_7498.method_7623();
        return result;
    }

    private static ItemConsumptionResult consumeItemAmountFromInventoryNoSync(class_1657 player, class_1935 ammunitionItem, int amountToConsume, boolean consume) {
        class_1661 playerInventory = player.method_31548();
        int remainingAmountToConsume = amountToConsume;
        block5: for (class_1799 playerItemStack : playerInventory.field_7547) {
            ItemConsumptionResult itemConsumptionResult;
            if (!playerItemStack.method_31574((class_1792)AVPBlockItems.AMMO_CHEST.get())) continue;
            ItemConsumptionResult result = GunReloading.consumeFromAmmoChestItem(playerItemStack, remainingAmountToConsume, ammunitionItem, consume);
            Objects.requireNonNull(result);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ItemConsumptionResult.Full.class, ItemConsumptionResult.Partial.class, ItemConsumptionResult.None.class}, (Object)itemConsumptionResult, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    ItemConsumptionResult.Full full = (ItemConsumptionResult.Full)itemConsumptionResult;
                    return full;
                }
                case 1: {
                    ItemConsumptionResult.Partial partial = (ItemConsumptionResult.Partial)itemConsumptionResult;
                    remainingAmountToConsume = partial.remainingAmount;
                    continue block5;
                }
                case 2: 
            }
            ItemConsumptionResult.None none = (ItemConsumptionResult.None)itemConsumptionResult;
        }
        for (class_1799 playerItemStack : playerInventory.field_7547) {
            if (!playerItemStack.method_31574(ammunitionItem.method_8389())) continue;
            int consumeCount = Math.min(playerItemStack.method_7947(), remainingAmountToConsume);
            if (consume) {
                playerItemStack.method_7934(consumeCount);
            }
            if ((remainingAmountToConsume -= consumeCount) != 0) continue;
            return ItemConsumptionResult.Full.INSTANCE;
        }
        if (remainingAmountToConsume == amountToConsume) {
            return ItemConsumptionResult.None.INSTANCE;
        }
        return new ItemConsumptionResult.Partial(remainingAmountToConsume);
    }

    private static ItemConsumptionResult consumeFromAmmoChestItem(class_1799 ammoChestStack, int amountToConsume, class_1935 ammunitionItem, boolean consume) {
        class_9288 container = (class_9288)ammoChestStack.method_57824(class_9334.field_49622);
        if (container == null || amountToConsume <= 0) {
            return ItemConsumptionResult.None.INSTANCE;
        }
        int remainingAmountToConsume = amountToConsume;
        for (class_1799 itemStack : container.method_59714()) {
            if (!itemStack.method_31574(ammunitionItem.method_8389())) continue;
            int consumeCount = Math.min(itemStack.method_7947(), remainingAmountToConsume);
            if (consume) {
                itemStack.method_7934(consumeCount);
            }
            if ((remainingAmountToConsume -= consumeCount) != 0) continue;
            return ItemConsumptionResult.Full.INSTANCE;
        }
        return new ItemConsumptionResult.Partial(remainingAmountToConsume);
    }

    public static sealed interface ItemConsumptionResult {

        public record Partial(int remainingAmount) implements ItemConsumptionResult
        {
        }

        public static enum Full implements ItemConsumptionResult
        {
            INSTANCE;

        }

        public static enum None implements ItemConsumptionResult
        {
            INSTANCE;

        }
    }
}

