/*
 * Decompiled with CFR 0.152.
 */
package com.human.common.gameplay.item.gun.attack.hitscan;

import com.avp.common.network.packet.C2SGunHitResultsPayload;
import com.avp.common.util.AVPPredicates;
import com.avp.service.Services;
import com.human.common.gameplay.item.gun.attack.GunAttackAction;
import com.human.common.gameplay.item.gun.attack.GunAttackConfig;
import com.human.common.gameplay.item.gun.attack.GunHitResult;
import com.human.common.gameplay.item.gun.attack.hitscan.GunHitScanAttackHandler;
import com.human.common.gameplay.item.gun.pipeline.GunShootResult;
import com.lib.common.gameplay.util.EnchantmentUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;

public class HitScanGunAttackAction
implements GunAttackAction {
    public static final HitScanGunAttackAction INSTANCE = new HitScanGunAttackAction();

    private HitScanGunAttackAction() {
    }

    @Override
    public GunShootResult shoot(GunAttackConfig gunAttackConfig) {
        class_1309 shooter = gunAttackConfig.shooter();
        class_1937 level = shooter.method_37908();
        double stepSize = 0.25;
        double maxDistance = gunAttackConfig.fireModeConfig().range();
        class_243 origin = shooter.method_33571();
        class_243 direction = shooter.method_5720().method_1029();
        HashSet<UUID> hitEntityUUIDs = new HashSet<UUID>();
        HashSet<class_2338> hitBlockPositions = new HashSet<class_2338>();
        ArrayList<GunHitResult> hitResults = new ArrayList<GunHitResult>();
        int totalPierces = 0;
        int piercingBudget = EnchantmentUtil.getLevel(level, gunAttackConfig.gunItemStack(), (class_5321<class_1887>)class_1893.field_9132) + 1;
        class_243 current = origin;
        double distanceTraveled = 0.0;
        while (distanceTraveled < maxDistance && totalPierces < piercingBudget) {
            class_2338 blockPos;
            class_3965 blockHit;
            class_243 next = current.method_1019(direction.method_1021(0.25));
            distanceTraveled += 0.25;
            class_3966 entityHit = class_1675.method_18077((class_1937)level, (class_1297)shooter, (class_243)current, (class_243)next, (class_238)shooter.method_5829().method_18804(direction.method_1021(maxDistance)).method_1014(1.0), entity -> !hitEntityUUIDs.contains(entity.method_5667()) && (entity.method_5864() == class_1299.field_6110 || AVPPredicates.isLiving(entity)));
            if (entityHit != null) {
                class_1297 entity2 = entityHit.method_17782();
                hitEntityUUIDs.add(entity2.method_5667());
                hitResults.add(new GunHitResult.Entity(entity2.method_5667()));
                ++totalPierces;
            }
            if ((blockHit = level.method_17742(new class_3959(current, next, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, (class_1297)shooter))).method_17783() == class_239.class_240.field_1332 && !hitBlockPositions.contains(blockPos = blockHit.method_17777())) {
                hitBlockPositions.add(blockPos);
                hitResults.add(new GunHitResult.Block(blockPos, blockHit.method_17780()));
                ++totalPierces;
            }
            current = next;
        }
        C2SGunHitResultsPayload gunHitResultsPayload = new C2SGunHitResultsPayload(hitResults);
        if (!level.field_9236 && !(shooter instanceof class_1657)) {
            GunHitScanAttackHandler.handle(gunHitResultsPayload, shooter);
            return GunShootResult.SHOT;
        }
        if (level.field_9236 && shooter instanceof class_1657) {
            class_1657 player = (class_1657)shooter;
            this.applyRecoilToPlayer(gunAttackConfig, player, level);
            Services.CLIENT_NETWORKING.sendToServer(gunHitResultsPayload);
            return GunShootResult.SHOT;
        }
        return GunShootResult.FAILURE;
    }

    private void applyRecoilToPlayer(GunAttackConfig gunAttackConfig, class_1657 player, class_1937 level) {
        float baseRecoilX = level.method_8409().method_43056() ? 1.0f : -1.0f;
        float recoil = gunAttackConfig.fireModeConfig().recoil();
        player.method_5872((double)(baseRecoilX * 2.0f), (double)(-recoil * 2.0f));
    }
}

