/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.data;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Objects;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public sealed interface EntityTypePredicate {
    public static final Codec<EntityTypePredicate> CODEC = Codec.either((Codec)Codec.STRING, (Codec)Codec.list((Codec)Codec.STRING)).flatXmap(EntityTypePredicate::decodePredicate, EntityTypePredicate::encodePredicate);

    public boolean test(class_1299<?> var1);

    private static DataResult<EntityTypePredicate> decodePredicate(Either<String, java.util.List<String>> either) {
        try {
            if (either.left().isPresent()) {
                String str = (String)either.left().get();
                if (str.startsWith("#")) {
                    class_2960 tagId = class_2960.method_60654((String)str.substring(1));
                    class_6862 tagKey = class_6862.method_40092((class_5321)class_7924.field_41266, (class_2960)tagId);
                    return DataResult.success((Object)new Tag(tagKey));
                }
                class_1299 entityType = (class_1299)class_1299.method_5898((String)str).orElseThrow(() -> new IllegalArgumentException("Unknown EntityType: " + str));
                return DataResult.success((Object)new Single(entityType));
            }
            java.util.List list = (java.util.List)either.right().get();
            java.util.List<class_1299> types = list.stream().map(class_1299::method_5898).map(opt -> opt.orElse(null)).filter(Objects::nonNull).toList();
            return DataResult.success((Object)new List(types));
        }
        catch (Exception e) {
            return DataResult.error(() -> "Invalid EntityTypePredicate: " + e.getMessage());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static DataResult<Either<String, java.util.List<String>>> encodePredicate(EntityTypePredicate predicate) {
        java.util.List<String> encoded;
        if (predicate instanceof Single) {
            class_1299<?> class_12992;
            Single single = (Single)predicate;
            class_1299<?> entityType = class_12992 = single.entityType();
            return DataResult.success((Object)Either.left((Object)class_1299.method_5890(entityType).toString()));
        }
        if (predicate instanceof Tag) {
            class_6862<class_1299<?>> class_68622;
            Tag tag = (Tag)predicate;
            class_6862<class_1299<?>> entityTypeTagKey = class_68622 = tag.entityTypeTagKey();
            return DataResult.success((Object)Either.left((Object)("#" + String.valueOf(entityTypeTagKey.comp_327()))));
        }
        if (!(predicate instanceof List)) return DataResult.error(() -> "Unknown EntityTypePredicate variant");
        List list2 = (List)predicate;
        try {
            java.util.List<class_1299<?>> list;
            java.util.List<class_1299<?>> entityTypes = list = list2.entityTypes();
            encoded = entityTypes.stream().map(class_1299::method_5890).map(class_2960::toString).toList();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        return DataResult.success((Object)Either.right(encoded));
    }

    public record Tag(class_6862<class_1299<?>> entityTypeTagKey) implements EntityTypePredicate
    {
        @Override
        public boolean test(class_1299<?> type) {
            return type.method_20210(this.entityTypeTagKey);
        }
    }

    public record Single(class_1299<?> entityType) implements EntityTypePredicate
    {
        @Override
        public boolean test(class_1299<?> type) {
            return this.entityType == type;
        }
    }

    public record List(java.util.List<? extends class_1299<?>> entityTypes) implements EntityTypePredicate
    {
        @Override
        public boolean test(class_1299<?> type) {
            return this.entityTypes.stream().anyMatch(type::equals);
        }
    }
}

