/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity;

import com.avp.common.util.AVPPredicates;
import com.just.codec.Codec;
import com.just.codec.impl.Codecs;
import com.lib.common.util.codec.impl.MojangCodecs;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1299;

public class EntityReserves {
    public static final Codec<EntityReserves> CODEC = Codec.unboundedMap(MojangCodecs.ENTITY_TYPE, (Codec)Codecs.INT).xmap(map -> {
        EntityReserves reserves = new EntityReserves();
        map.forEach(reserves::add);
        return reserves;
    }, EntityReserves::getBackingMap);
    private final Map<class_1299<?>, Integer> entityTypesToCountMap = new HashMap();

    public void add(class_1299<?> entityType, int count) {
        this.entityTypesToCountMap.compute(entityType, ($1, currentCount) -> {
            if (currentCount == null) {
                return Math.max(count, 0);
            }
            return Math.max(count + currentCount, 0);
        });
    }

    public void putAll(Map<class_1299<?>, Integer> map) {
        this.entityTypesToCountMap.putAll(map);
    }

    public int getCount(class_1299<?> entityType) {
        return this.entityTypesToCountMap.getOrDefault(entityType, 0);
    }

    public int getCount() {
        return this.getCountMatching(AVPPredicates.alwaysTrue());
    }

    public int getCountMatching(Predicate<class_1299<?>> predicate) {
        return this.entityTypesToCountMap.entrySet().stream().filter(entry -> predicate.test((class_1299)entry.getKey())).mapToInt(Map.Entry::getValue).sum();
    }

    public List<class_1299<?>> getAvailableEntityTypes() {
        return this.entityTypesToCountMap.keySet().stream().filter(key -> this.entityTypesToCountMap.getOrDefault(key, 0) > 0).toList();
    }

    public Map<class_1299<?>, Integer> getBackingMap() {
        return Collections.unmodifiableMap(this.entityTypesToCountMap);
    }
}

