/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.ai.action;

import com.just.core.functional.option.Option;
import com.lib.common.gameplay.goap.GOAPAction;
import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.condition.expression.GOAPExpression;
import com.lib.common.gameplay.goap.effect.GOAPEffect;
import com.lib.common.gameplay.goap.state.GOAPBlackboard;
import com.lib.common.gameplay.goap.state.GOAPWorldState;
import java.util.function.BiPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1324;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5134;

public class MoveToTargetEntityAction<T extends class_1308, E extends class_1297>
extends GOAPAction<T> {
    private final BiPredicate<GOAPWorldState, Double> distanceSqrIsInRangePredicate;
    private final TypedIdentifier<Option<? extends E>> nearestTargetIdentifier;
    private final double speedMultiplier;

    public MoveToTargetEntityAction(TypedIdentifier<Option<? extends E>> nearestTargetIdentifier, TypedIdentifier<Boolean> isInRangeIdentifier, double speedMultiplier, BiPredicate<GOAPWorldState, Double> distanceSqrIsInRangePredicate) {
        this.distanceSqrIsInRangePredicate = distanceSqrIsInRangePredicate;
        this.nearestTargetIdentifier = nearestTargetIdentifier;
        this.speedMultiplier = speedMultiplier;
        this.addPrecondition(nearestTargetIdentifier, GOAPExpression.isSome());
        this.addPrecondition(isInRangeIdentifier, GOAPExpression.isFalse());
        this.addEffect(new GOAPEffect.Value<Boolean>(isInRangeIdentifier, true));
    }

    @Override
    public boolean perform(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        Option targetEntityOption = (Option)worldState.getOrDefault(this.nearestTargetIdentifier, Option.none());
        if (targetEntityOption.isNone()) {
            return true;
        }
        class_1297 target = (class_1297)targetEntityOption.unwrap();
        if (this.distanceSqrIsInRangePredicate.test(worldState, context.method_5858(target))) {
            return true;
        }
        class_2338 targetPos = target.method_24515().method_10074();
        class_2680 state = context.method_37908().method_8320(targetPos);
        if (state.method_26168((class_1922)context.method_37908(), targetPos, context)) {
            context.method_5942().method_6335(target, this.speedMultiplier);
        }
        return false;
    }

    @Override
    public void onFinish(T context, GOAPWorldState worldState, GOAPBlackboard blackboard) {
        context.method_5942().method_6340();
    }

    @Override
    public float getCost(T context, GOAPWorldState worldState) {
        return ((Float)((Option)worldState.getOrDefault(this.nearestTargetIdentifier, Option.none())).match(target -> {
            float distSqr = (float)context.method_5858(target);
            class_1324 attribute = context.method_5996(class_5134.field_23717);
            float maxDistance = attribute == null ? 16.0f : (float)attribute.method_6194();
            return Float.valueOf(Math.clamp(distSqr / (maxDistance * maxDistance), 0.0f, 1.0f));
        }, () -> Float.valueOf(1.0f))).floatValue();
    }
}

