/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.entity.manager;

import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.gameplay.entity.manager.GeneContainer;
import com.lib.common.gameplay.entity.manager.GeneMap;
import com.lib.common.gameplay.gene.Gene;
import com.lib.common.gameplay.gene.GeneModifierKey;
import com.lib.common.gameplay.gene.GeneOperationType;
import com.lib.common.gameplay.gene.GeneRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_5134;

public class GeneManager
implements NBTSerializable {
    private final class_1309 entity;
    private final GeneContainer geneContainer;

    public GeneManager(class_1309 entity) {
        this.entity = entity;
        this.geneContainer = new GeneContainer();
    }

    public void tick() {
        GeneMap activeGeneMap = this.geneContainer.getActiveGeneMap();
        if (this.entity.method_37908().field_9236 || !activeGeneMap.isDirty()) {
            return;
        }
        float oldMaxHealth = this.entity.method_6063();
        boolean wasFullHealth = this.entity.method_6032() == oldMaxHealth;
        activeGeneMap.getDirtyKeys().forEach(this::applyGeneEffects);
        class_1324 maxHealthAttributeInstance = this.entity.method_5996(class_5134.field_23716);
        if (maxHealthAttributeInstance != null) {
            double newMax = maxHealthAttributeInstance.method_6194();
            float currentHealth = this.entity.method_6032();
            if (wasFullHealth || (double)currentHealth > newMax) {
                this.entity.method_6033((float)newMax);
            }
        }
        activeGeneMap.clearDirtyKeys();
    }

    private void applyGeneEffects(GeneModifierKey dirtyGeneModifierKey) {
        GeneMap activeGeneMap = this.geneContainer.getActiveGeneMap();
        class_2960 id = dirtyGeneModifierKey.resourceLocation();
        Gene gene = GeneRegistry.getValueOrNull(id);
        if (gene == null) {
            return;
        }
        Gene gene2 = gene;
        Objects.requireNonNull(gene2);
        Gene gene3 = gene2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Gene.Attribute.class, Gene.Effect.class, Gene.Simple.class}, (Object)gene3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                Gene.Attribute attribute = (Gene.Attribute)gene3;
                class_1324 attributeInstance = this.entity.method_5996(attribute.attributeHolder());
                if (attributeInstance == null) break;
                boolean hasGeneModifier = activeGeneMap.hasGeneModifier(dirtyGeneModifierKey);
                if (hasGeneModifier) {
                    this.applyGeneAttributeBonus(dirtyGeneModifierKey, attributeInstance);
                    break;
                }
                attributeInstance.method_6200(id);
                break;
            }
            case 1: {
                Gene.Effect effectGene = (Gene.Effect)gene3;
                effectGene.onChange().accept(this.entity);
                break;
            }
            case 2: {
                Gene.Simple simple = (Gene.Simple)gene3;
            }
        }
    }

    private void applyGeneAttributeBonus(GeneModifierKey geneModifierKey, class_1324 attributeInstance) {
        class_2960 id = geneModifierKey.resourceLocation();
        Gene gene = GeneRegistry.getValueOrNull(id);
        double bonusValue = this.geneContainer.getActiveGeneMap().getValue(gene, geneModifierKey.operation());
        double finalBonusValue = switch (geneModifierKey.operation()) {
            default -> throw new MatchException(null, null);
            case GeneOperationType.ADDITIVE -> bonusValue;
            case GeneOperationType.MULTIPLICATIVE -> attributeInstance.method_6201() * bonusValue;
        };
        class_1322 modifier = new class_1322(id, finalBonusValue, class_1322.class_1323.field_6328);
        attributeInstance.method_61163(modifier);
    }

    public GeneContainer getGeneContainer() {
        return this.geneContainer;
    }

    @Override
    public void load(class_2487 compoundTag) {
        this.geneContainer.load(compoundTag);
    }

    @Override
    public void save(class_2487 compoundTag) {
        this.geneContainer.save(compoundTag);
    }
}

