/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.gameplay.goap.effect;

import com.lib.common.gameplay.goap.TypedIdentifier;
import com.lib.common.gameplay.goap.state.GOAPMutableWorldState;
import java.util.function.UnaryOperator;

public sealed interface GOAPEffect<T> {
    public TypedIdentifier<T> identifier();

    public void apply(GOAPMutableWorldState var1);

    public record Dynamic<T>(TypedIdentifier<T> identifier, UnaryOperator<T> consumer) implements GOAPEffect<T>
    {
        @Override
        public void apply(GOAPMutableWorldState worldState) {
            T existingValue = worldState.get(this.identifier);
            if (existingValue != null) {
                Object updatedValue = this.consumer.apply(existingValue);
                worldState.set(this.identifier, updatedValue);
            }
        }
    }

    public record Value<T>(TypedIdentifier<T> identifier, T value) implements GOAPEffect<T>
    {
        @Override
        public void apply(GOAPMutableWorldState worldState) {
            worldState.set(this.identifier, this.value);
        }
    }
}

