/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.network;

import com.avp.AVP;
import com.avp.common.network.packet.S2CEntityDataSyncPayload;
import com.avp.service.Services;
import com.just.codec.stream.StreamCodec;
import com.just.codec.stream.schema.StreamCodecSchema;
import com.just.core.functional.option.Option;
import com.lib.common.gameplay.NBTSerializable;
import com.lib.common.network.DataKey;
import com.lib.common.network.RawDataSyncMap;
import com.lib.common.registry.DataKeyRegistry;
import com.lib.common.util.codec.stream.schema.StreamCodecSchemas;
import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2540;

public class DataContainer
implements NBTSerializable {
    private final Set<DataKey<?>> dirtyKeys = new HashSet();
    private final Map<DataKey<?>, Consumer<?>> onChangeCallbacks = new HashMap();
    private final Map<DataKey<?>, Consumer<?>> onLoadCallbacks = new HashMap();
    private final Map<DataKey<?>, Object> values = new HashMap();

    public <T> void setOnChangeCallback(DataKey<T> dataKey, Consumer<T> callback) {
        this.onChangeCallbacks.put(dataKey, callback);
    }

    public <T> void setOnLoadCallback(DataKey<T> dataKey, Consumer<T> callback) {
        this.onLoadCallbacks.put(dataKey, callback);
    }

    public <T> T get(DataKey<T> key) {
        return (T)this.values.getOrDefault(key, key.initialValue());
    }

    public <T> void set(DataKey<T> key, T value) {
        if (!Objects.equals(this.values.get(key), value)) {
            this.values.put(key, value);
            Consumer<?> onChangeCallback = this.onChangeCallbacks.get(key);
            if (onChangeCallback != null) {
                onChangeCallback.accept(value);
            }
            if (key.streamCodec().isSome()) {
                this.dirtyKeys.add(key);
            }
        }
    }

    public void set(int id, byte[] rawData) {
        DataKey<?> key = DataKeyRegistry.getDataKeyOrNull(id);
        if (key == null) {
            return;
        }
        StreamCodec codec = (StreamCodec)key.streamCodec().unwrap();
        ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])rawData);
        class_2540 friendlyByteBuf = new class_2540(byteBuf);
        Object value = codec.decode((StreamCodecSchema)StreamCodecSchemas.BYTE_BUF, (Object)friendlyByteBuf);
        this.set(key, value);
    }

    public void syncToClient(class_1297 entity, SyncType syncType) {
        if (entity.method_37908().field_9236) {
            return;
        }
        if (syncType == SyncType.DIRTY && !this.isDirty()) {
            return;
        }
        Map<Integer, byte[]> dataMap = this.values.keySet().stream().filter(key -> syncType != SyncType.DIRTY || this.dirtyKeys.contains(key)).filter(key -> key.streamCodec().isSome() && DataKeyRegistry.getIdOrNull(key.id()) != null).map(key -> {
            Integer id = Objects.requireNonNull(DataKeyRegistry.getIdOrNull(key.id()));
            StreamCodec codec = (StreamCodec)key.streamCodec().unwrap();
            Object value = this.get((DataKey)key);
            class_2540 friendlyByteBuf = new class_2540(Unpooled.buffer());
            codec.encode((StreamCodecSchema)StreamCodecSchemas.BYTE_BUF, (Object)friendlyByteBuf, value);
            return Map.entry(id, ByteBufUtil.getBytes((ByteBuf)friendlyByteBuf));
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        RawDataSyncMap rawDataSyncMap = new RawDataSyncMap(dataMap);
        Services.SERVER_NETWORKING.sendToAllClients(entity.method_37908().method_8503(), new S2CEntityDataSyncPayload(entity.method_5628(), rawDataSyncMap));
        this.dirtyKeys.clear();
    }

    public boolean isDirty() {
        return !this.dirtyKeys.isEmpty();
    }

    @Override
    public void load(class_2487 compoundTag) {
        this.values.keySet().forEach(key -> {
            Consumer<?> onLoadCallback = this.onLoadCallbacks.get(key);
            key.persistenceMetadata().ifSome(persistenceMetadata -> {
                Object value;
                String id = persistenceMetadata.key();
                if (!compoundTag.method_10545(id)) {
                    return;
                }
                Codec codec = persistenceMetadata.codec();
                if (codec == Codec.BOOL) {
                    boolean value2 = compoundTag.method_10577(id);
                    this.values.put((DataKey<?>)key, value2);
                    if (onLoadCallback != null) {
                        onLoadCallback.accept(value2);
                    }
                    return;
                }
                byte tagType = compoundTag.method_10540(id);
                switch (tagType) {
                    case 1: {
                        Object object = compoundTag.method_10571(id);
                        break;
                    }
                    case 2: {
                        Object object = compoundTag.method_10568(id);
                        break;
                    }
                    case 3: {
                        Object object = compoundTag.method_10550(id);
                        break;
                    }
                    case 4: {
                        Object object = compoundTag.method_10537(id);
                        break;
                    }
                    case 5: {
                        Object object = Float.valueOf(compoundTag.method_10583(id));
                        break;
                    }
                    case 6: {
                        Object object = compoundTag.method_10574(id);
                        break;
                    }
                    case 8: {
                        Object object = compoundTag.method_10558(id);
                        break;
                    }
                    case 7: {
                        Object object = compoundTag.method_10547(id);
                        break;
                    }
                    case 11: {
                        Object object = compoundTag.method_10561(id);
                        break;
                    }
                    case 12: {
                        Object object = compoundTag.method_10565(id);
                        break;
                    }
                    default: {
                        AVP.LOGGER.error("Failed to decode key '{}': Unrecognized Tag type: '{}'", (Object)id, (Object)tagType);
                        Object object = value = null;
                    }
                }
                if (value != null) {
                    DataKey typedKey = key;
                    this.values.put(typedKey, value);
                    if (onLoadCallback != null) {
                        onLoadCallback.accept(value);
                    }
                }
            });
        });
    }

    @Override
    public void save(class_2487 compoundTag) {
        this.values.forEach((key, value) -> {
            Option persistenceMetadataOption = key.persistenceMetadata();
            persistenceMetadataOption.ifSome(persistenceMetadata -> {
                String id = persistenceMetadata.key();
                Object selector0$temp = value;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Byte.class, Short.class, Integer.class, Boolean.class, Long.class, Float.class, Double.class, String.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        Byte b = (Byte)selector0$temp;
                        compoundTag.method_10567(id, b.byteValue());
                        break;
                    }
                    case 1: {
                        Short s = (Short)selector0$temp;
                        compoundTag.method_10575(id, s.shortValue());
                        break;
                    }
                    case 2: {
                        Integer i = (Integer)selector0$temp;
                        compoundTag.method_10569(id, i.intValue());
                        break;
                    }
                    case 3: {
                        Boolean bool = (Boolean)selector0$temp;
                        compoundTag.method_10556(id, bool.booleanValue());
                        break;
                    }
                    case 4: {
                        Long l = (Long)selector0$temp;
                        compoundTag.method_10544(id, l.longValue());
                        break;
                    }
                    case 5: {
                        Float f = (Float)selector0$temp;
                        compoundTag.method_10548(id, f.floatValue());
                        break;
                    }
                    case 6: {
                        Double d = (Double)selector0$temp;
                        compoundTag.method_10549(id, d.doubleValue());
                        break;
                    }
                    case 7: {
                        String s = (String)selector0$temp;
                        compoundTag.method_10582(id, s);
                        break;
                    }
                    default: {
                        AVP.LOGGER.error("Failed to encode key '{}': Unrecognized value type. Value: '{}'", (Object)id, value);
                    }
                }
            });
        });
    }

    public static enum SyncType {
        ALL,
        DIRTY;

    }
}

