/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util.codec.adapter;

import com.just.codec.schema.CodecSchema;
import com.just.core.functional.result.Result;
import com.just.core.functional.tuple.Tuple2;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import java.util.stream.Stream;

public class DynamicOpsToCodecSchemaAdapter<T>
implements CodecSchema<T> {
    private final DynamicOps<T> dynamicOps;

    public DynamicOpsToCodecSchemaAdapter(DynamicOps<T> dynamicOps) {
        this.dynamicOps = dynamicOps;
    }

    public T empty() {
        return (T)this.dynamicOps.empty();
    }

    public Result<Boolean, T> getBooleanValue(T input) {
        return (Result)this.dynamicOps.getBooleanValue(input).mapOrElse(Result::ok, e -> Result.err((Object)input));
    }

    public Result<Number, T> getNumberValue(T input) {
        return (Result)this.dynamicOps.getNumberValue(input).mapOrElse(Result::ok, e -> Result.err((Object)input));
    }

    public Result<String, T> getStringValue(T input) {
        return (Result)this.dynamicOps.getStringValue(input).mapOrElse(Result::ok, e -> Result.err((Object)input));
    }

    public Result<Stream<T>, T> getStream(T input) {
        return (Result)this.dynamicOps.getStream(input).mapOrElse(Result::ok, e -> Result.err((Object)input));
    }

    public Result<Stream<Tuple2<T, T>>, T> getMap(T input) {
        return (Result)this.dynamicOps.getMap(input).mapOrElse(map -> Result.ok(map.entries().map(pair -> new Tuple2(pair.getFirst(), pair.getSecond()))), e -> Result.err((Object)input));
    }

    public Result<T, T> getField(T map, String key) {
        return (Result)this.dynamicOps.get(map, key).mapOrElse(Result::ok, e -> Result.err((Object)map));
    }

    public T createBooleanValue(boolean value) {
        return (T)this.dynamicOps.createBoolean(value);
    }

    public T createNumber(Number value) {
        return (T)this.dynamicOps.createNumeric(value);
    }

    public T createStringValue(String value) {
        return (T)this.dynamicOps.createString(value);
    }

    public T createList(Stream<T> elements) {
        return (T)this.dynamicOps.createList(elements);
    }

    public T createMap(Stream<Tuple2<T, T>> entries) {
        return (T)this.dynamicOps.createMap(entries.map(tuple2 -> new Pair(tuple2.v1(), tuple2.v2())));
    }

    public T createField(T map, String key, T value) {
        return (T)this.dynamicOps.set(map, key, value);
    }
}

