/*
 * Decompiled with CFR 0.152.
 */
package com.lib.common.util.codec.stream.impl;

import com.avp.common.model.DataComponentPatchAccessor;
import com.avp.mixin.MixinDataComponentPatch;
import com.just.codec.stream.StreamCodec;
import com.just.codec.stream.impl.StreamCodecs;
import com.just.codec.stream.schema.StreamCodecSchema;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import java.util.ArrayList;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9129;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MojangStreamCodecs {
    public static final StreamCodec<class_2338> BLOCK_POS = new StreamCodec<class_2338>(){

        @NotNull
        public <T> class_2338 decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            return class_2338.method_10092((long)streamCodecSchema.readLong(input));
        }

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull class_2338 value) {
            streamCodecSchema.writeLong(input, value.method_10063());
        }
    };
    public static final StreamCodec<class_9326> DATA_COMPONENT_PATCH = new StreamCodec<class_9326>(){

        public <T> void encode(@NotNull StreamCodecSchema<T> schema, @NotNull T input, @NotNull class_9326 patch) {
            if (patch.method_57848()) {
                schema.writeInt(input, 0);
                schema.writeInt(input, 0);
                return;
            }
            ArrayList<Reference2ObjectMap.Entry> present = new ArrayList<Reference2ObjectMap.Entry>();
            ArrayList<class_9331> removed = new ArrayList<class_9331>();
            Reference2ObjectMap<class_9331<?>, Optional<?>> map = ((DataComponentPatchAccessor)patch).avp$getMap();
            for (Reference2ObjectMap.Entry entry : map.reference2ObjectEntrySet()) {
                if (((Optional)entry.getValue()).isPresent()) {
                    present.add(entry);
                    continue;
                }
                removed.add((class_9331)entry.getKey());
            }
            schema.writeInt(input, present.size());
            schema.writeInt(input, removed.size());
            for (Map.Entry entry : present) {
                class_9331 type = (class_9331)entry.getKey();
                Object value = ((Optional)entry.getValue()).orElseThrow();
                schema.write(input, DATA_COMPONENT_TYPE, (Object)type);
                2.encodeComponent(input, type, value);
            }
            for (class_9331 class_93312 : removed) {
                schema.write(input, DATA_COMPONENT_TYPE, (Object)class_93312);
            }
        }

        @NotNull
        public <T> class_9326 decode(@NotNull StreamCodecSchema<T> schema, @NotNull T input) {
            class_9331 type;
            int i;
            int presentCount = schema.readInt(input);
            int removedCount = schema.readInt(input);
            if (presentCount == 0 && removedCount == 0) {
                return class_9326.field_49588;
            }
            Reference2ObjectArrayMap map = new Reference2ObjectArrayMap(Math.min(presentCount + removedCount, 65536));
            for (i = 0; i < presentCount; ++i) {
                type = (class_9331)schema.read(input, DATA_COMPONENT_TYPE);
                Object value = 2.decodeComponent(input, type);
                map.put((Object)type, Optional.ofNullable(value));
            }
            for (i = 0; i < removedCount; ++i) {
                type = (class_9331)schema.read(input, DATA_COMPONENT_TYPE);
                map.put((Object)type, Optional.empty());
            }
            return MixinDataComponentPatch.avp$construct(map);
        }

        private static <A, T> void encodeComponent(T input, class_9331<A> type, A value) {
            if (input instanceof class_9129) {
                class_9129 byteBuf = (class_9129)input;
                type.method_57878().encode((Object)byteBuf, value);
                return;
            }
            throw new UnsupportedOperationException();
        }

        @Nullable
        private static <A, T> A decodeComponent(T input, class_9331<A> type) {
            if (input instanceof class_9129) {
                class_9129 byteBuf = (class_9129)input;
                return (A)type.method_57878().decode((Object)byteBuf);
            }
            return null;
        }
    };
    public static final StreamCodec<class_9331<?>> DATA_COMPONENT_TYPE = new StreamCodec<class_9331<?>>(){

        @NotNull
        public <T> class_9331<?> decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            int typeId = streamCodecSchema.readVarInt(input);
            return (class_9331)class_7923.field_49658.method_39974(typeId);
        }

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull class_9331<?> value) {
            int typeId = class_7923.field_49658.method_56158(value);
            streamCodecSchema.writeVarInt(input, typeId);
        }
    };
    public static final StreamCodec<class_2350> DIRECTION = new StreamCodec<class_2350>(){

        @NotNull
        public <T> class_2350 decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            return class_2350.method_10143((int)streamCodecSchema.readByte(input));
        }

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull class_2350 value) {
            streamCodecSchema.writeByte(input, (byte)value.method_10146());
        }
    };
    public static final StreamCodec<class_1799> ITEM_STACK = new StreamCodec<class_1799>(){

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull class_1799 value) {
            if (value.method_7960()) {
                streamCodecSchema.writeVarInt(input, 0);
            } else {
                streamCodecSchema.writeVarInt(input, value.method_7947());
                int itemId = class_7923.field_41178.method_56158((Object)value.method_7909());
                streamCodecSchema.writeVarInt(input, itemId);
                streamCodecSchema.write(input, DATA_COMPONENT_PATCH, (Object)value.method_57380());
            }
        }

        @NotNull
        public <T> class_1799 decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            int size = streamCodecSchema.readVarInt(input);
            if (size <= 0) {
                return class_1799.field_8037;
            }
            class_6880 itemHolder = (class_6880)class_7923.field_41178.method_40295().method_39974(streamCodecSchema.readVarInt(input));
            class_9326 datacomponentpatch = (class_9326)DATA_COMPONENT_PATCH.decode(streamCodecSchema, input);
            return new class_1799(itemHolder, size, datacomponentpatch);
        }
    };
    public static final StreamCodec<class_2960> RESOURCE_LOCATION = new StreamCodec<class_2960>(){

        @NotNull
        public <T> class_2960 decode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input) {
            return class_2960.method_60654((String)((String)streamCodecSchema.read(input, StreamCodecs.STRING_UTF8)));
        }

        public <T> void encode(@NotNull StreamCodecSchema<T> streamCodecSchema, @NotNull T input, @NotNull class_2960 value) {
            streamCodecSchema.write(input, StreamCodecs.STRING_UTF8, (Object)value.toString());
        }
    };
}

