/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.animation.entity;

import com.alien.common.gameplay.entity.living.alien.xenomorph.spitter.Spitter;
import com.alien.common.gameplay.entity.living.alien.xenomorph.spitter.SpitterAnimationDispatcher;
import com.avp.AVPResources;
import mod.azure.azurelib.common.animation.AzAnimator;
import mod.azure.azurelib.common.animation.AzAnimatorConfig;
import mod.azure.azurelib.common.animation.controller.AzAnimationController;
import mod.azure.azurelib.common.animation.controller.AzAnimationControllerContainer;
import mod.azure.azurelib.common.animation.impl.AzEntityAnimator;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class SpitterAnimator
extends AzEntityAnimator<Spitter> {
    private static final String NAME = "spitter";
    private static final ResourceLocation ANIMATION = AVPResources.entityAnimationLocation("spitter");

    public SpitterAnimator() {
        super(AzAnimatorConfig.defaultConfig());
    }

    public void registerControllers(AzAnimationControllerContainer<Spitter> animationControllerContainer) {
        animationControllerContainer.add(AzAnimationController.builder((AzAnimator)this, (String)"body").setTransitionLength(5).build(), new AzAnimationController[]{AzAnimationController.builder((AzAnimator)this, (String)"head").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"leftarm").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"leftleg").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"rightarm").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"rightleg").setTransitionLength(5).build(), AzAnimationController.builder((AzAnimator)this, (String)"tail").setTransitionLength(5).build()});
    }

    @NotNull
    public ResourceLocation getAnimationLocation(Spitter animatable) {
        return ANIMATION;
    }

    public void setCustomAnimations(Spitter animatable, float partialTicks) {
        super.setCustomAnimations((Object)animatable, partialTicks);
        this.runPassiveAnimations(animatable);
    }

    private void runPassiveAnimations(Spitter spitter) {
        SpitterAnimationDispatcher dispatcher = spitter.getAnimationDispatcher();
        boolean isMovingOnGround = (Boolean)spitter.isMovingHorizontally.get() != false && spitter.onGround();
        boolean isCrawling = spitter.getCrawlingManager().isCrawling();
        Runnable animFunction = spitter.isUnderWater() ? dispatcher::swim : (isMovingOnGround ? (isCrawling ? dispatcher::crawl : (((Boolean)spitter.hasTarget.get()).booleanValue() ? dispatcher::run : dispatcher::walk)) : (isCrawling ? dispatcher::crawlHold : dispatcher::idle));
        animFunction.run();
    }
}

