/*
 * Decompiled with CFR 0.152.
 */
package com.alien.client.render;

import com.alien.common.model.alien.variant.AlienVariant;
import com.avp.AVPResources;
import java.util.function.Function;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;

public class AlienRenderResourceCache {
    private static final int ROYAL_FLAG = 1;
    private final String baseName;
    private final Function<ResourceLocation, RenderType> renderTypeFunction;
    private final ResourceLocation[] modelLocations;
    private final ResourceLocation[] textureLocations;
    private final RenderType[] renderTypes;

    public AlienRenderResourceCache(String baseName, Function<ResourceLocation, RenderType> renderTypeFunction) {
        this.baseName = baseName;
        this.renderTypeFunction = renderTypeFunction;
        int size = AlienVariant.VALUES.length * 2;
        this.modelLocations = new ResourceLocation[size];
        this.textureLocations = new ResourceLocation[size];
        this.renderTypes = new RenderType[size];
    }

    public ResourceLocation getOrCreateModelLocationForVariant(AlienVariant variant) {
        return this.getOrCreateModelLocationForVariant(variant, false);
    }

    public ResourceLocation getOrCreateModelLocationForVariant(AlienVariant variant, boolean isRoyal) {
        int index = this.getIndex(variant, isRoyal);
        ResourceLocation modelLocation = this.modelLocations[index];
        if (modelLocation == null) {
            this.modelLocations[index] = modelLocation = AVPResources.entityGeoModelLocation(this.getResourceName(variant, isRoyal));
        }
        return modelLocation;
    }

    public ResourceLocation getOrCreateTextureLocationForVariant(AlienVariant variant) {
        return this.getOrCreateTextureLocationForVariant(variant, false);
    }

    public ResourceLocation getOrCreateTextureLocationForVariant(AlienVariant variant, boolean isRoyal) {
        int index = this.getIndex(variant, isRoyal);
        ResourceLocation textureLocation = this.textureLocations[index];
        if (textureLocation == null) {
            this.textureLocations[index] = textureLocation = AVPResources.entityTextureLocation(this.getResourceName(variant, isRoyal));
        }
        return textureLocation;
    }

    public RenderType getOrCreateRenderTypeForVariant(AlienVariant variant) {
        return this.getOrCreateRenderTypeForVariant(variant, false);
    }

    public RenderType getOrCreateRenderTypeForVariant(AlienVariant variant, boolean isRoyal) {
        int index = this.getIndex(variant, isRoyal);
        RenderType renderType = this.renderTypes[index];
        if (renderType == null) {
            ResourceLocation texLoc = this.getOrCreateTextureLocationForVariant(variant, isRoyal);
            this.renderTypes[index] = renderType = this.renderTypeFunction.apply(texLoc);
        }
        return renderType;
    }

    private String getResourceName(AlienVariant alienVariant, boolean isRoyal) {
        return this.getPrefixForRoyalResourceLocation(isRoyal) + this.getPrefixForVariantResourceLocation(alienVariant) + this.baseName;
    }

    public String getPrefixForRoyalResourceLocation(boolean isRoyal) {
        return isRoyal ? "royal_" : "";
    }

    public String getPrefixForVariantResourceLocation(AlienVariant alienVariant) {
        return switch (alienVariant) {
            default -> throw new MatchException(null, null);
            case AlienVariant.NORMAL -> "";
            case AlienVariant.NETHER -> "nether_";
            case AlienVariant.ABERRANT -> "aberrant_";
            case AlienVariant.IRRADIATED -> "irradiated_";
        };
    }

    private int getIndex(AlienVariant variant, boolean isRoyal) {
        return variant.ordinal() << 1 | (isRoyal ? 1 : 0);
    }
}

