/*
 * Decompiled with CFR 0.152.
 */
package com.alien.common.gameplay.entity.acid;

import com.alien.common.gameplay.entity.acid.Acid;
import com.avp.AVP;
import com.avp.common.registry.key.AVPDamageTypeKeys;
import com.avp.common.registry.tag.AVPEntityTypeTags;
import com.avp.common.registry.tag.AVPItemTags;
import com.avp.common.util.AVPPredicates;
import java.util.Objects;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class AcidEntityDamageUtil {
    public static void damageEntities(Acid acid) {
        Level level = acid.level();
        if (level.isClientSide || acid.isInWater() || acid.tickCount % 10 != 0) {
            return;
        }
        level.getEntities((Entity)acid, acid.getBoundingBox(), entity -> AVPPredicates.isLiving(entity) || entity instanceof Acid).stream().filter(entity -> {
            Player player;
            if (entity instanceof Acid) {
                Acid otherAcid = (Acid)entity;
                if (otherAcid.isAlive() && Objects.equals(acid.isNetherAfflicted(), otherAcid.isNetherAfflicted())) {
                    otherAcid.remove(Entity.RemovalReason.DISCARDED);
                    acid.setMultiplier(acid.getMultiplier() + otherAcid.getMultiplier());
                }
                return false;
            }
            boolean isImmortalPlayer = entity instanceof Player && AVPPredicates.IS_IMMORTAL.test((LivingEntity)(player = (Player)entity));
            return entity.isAlive() && !isImmortalPlayer;
        }).forEach(entity -> AcidEntityDamageUtil.damageEntity(acid, entity));
    }

    private static void damageEntity(Acid acid, Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            ItemStack itemStack = livingEntity.getItemBySlot(EquipmentSlot.FEET);
            if (itemStack.is(AVPItemTags.ACID_IMMUNE)) {
                return;
            }
            if (!itemStack.isEmpty() && !acid.isIrradiated()) {
                AcidEntityDamageUtil.damageFootwear(acid, itemStack);
                return;
            }
        }
        if (entity.getType().is(AVPEntityTypeTags.ACID_IMMUNE)) {
            return;
        }
        float damage = AVP.config.statsConfigs.ACID_ATTACK_DAMAGE;
        Registry registry = acid.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE);
        DamageSource damageSource = new DamageSource((Holder)registry.getHolderOrThrow(AVPDamageTypeKeys.ACID));
        if (acid.isNetherAfflicted()) {
            entity.igniteForTicks(100);
        }
        if (acid.isIrradiated()) {
            entity.setIsInPowderSnow(true);
        }
        if (!acid.isIrradiated()) {
            entity.hurt(damageSource, damage * (float)acid.getMultiplier());
        }
    }

    private static void damageFootwear(Acid acid, ItemStack itemStack) {
        ServerLevel level = (ServerLevel)acid.level();
        int damage = (acid.getRandom().nextInt(3) + 3) * acid.getMultiplier();
        itemStack.hurtAndBreak(damage, level, null, item -> {});
    }
}

